/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.base.Throwables;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.textures.SpriteSub;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TextureLocation
implements ISolidWorldTexture {
    protected final String[] textures;
    protected final String[] baseTexture = new String[6];

    public TextureLocation(String texture) {
        ResourceLocation resourcelocation = new ResourceLocation("extrautils2:connected/" + texture);
        ResourceLocation resourcelocation1 = Textures.completeTextureResourceLocation(resourcelocation);
        try (IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourcelocation1);){
            BufferedImage read = ImageIO.read(iresource.func_110527_b());
            int w = read.getWidth();
            int h = read.getHeight();
            if (h % w != 0) {
                throw new RuntimeException("Height must be a multiple of the width.");
            }
            int n = h / w;
            this.textures = new String[n];
            for (int i = 0; i < n; ++i) {
                String key;
                this.textures[i] = key = texture + "#" + i;
                Textures.textureNames.put(key, new SpriteSub("connected/" + texture, 0, i, 1, n, 1));
            }
            this.assignBaseTextures();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected abstract void assignBaseTextures();

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getWorldIcon(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        int a = this.getRandomIndex(world, blockPos, side);
        int l = a % this.textures.length;
        return Textures.getSprite(this.textures[l]);
    }

    protected abstract int getRandomIndex(IBlockAccess var1, BlockPos var2, EnumFacing var3);

    @Override
    public String getItemTexture(EnumFacing side) {
        return this.baseTexture[side.ordinal()];
    }
}

