/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.energy;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.SpecialChat;
import com.rwtema.extrautils2.particles.PacketParticleSplineCurve;
import com.rwtema.extrautils2.power.IPowerSubType;
import com.rwtema.extrautils2.power.energy.EnergyTransfer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.VecHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TilePowerTransmitter
extends TilePower
implements IPowerSubType {
    public static final int VELOCITY = 4;
    public static final int RANGE = 4;
    List<BlockPos> nearbyEnergyTiles;

    public List<BlockPos> getTargets(boolean rebuild) {
        if (rebuild || this.nearbyEnergyTiles == null) {
            return this.refreshTiles();
        }
        return this.nearbyEnergyTiles;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TextComponentTranslation chat;
            List<BlockPos> list = this.refreshTiles();
            if (list == null || list.isEmpty()) {
                chat = Lang.chat("No nearby tiles", new Object[0]);
            } else {
                chat = Lang.chat("Serving %s tiles", list.size());
                EnumFacing s = (EnumFacing)this.getBlockState().func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
                Vec3d start = VecHelper.addSide(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), s, 0.375);
                Vec3d startVel = VecHelper.addSide(Vec3d.field_186680_a, s, -4.0);
                block0: for (BlockPos blockPos : list) {
                    final TileEntity tileEntity = worldIn.func_175625_s(blockPos);
                    if (tileEntity == null || !EnergyTransfer.isValidOutput(tileEntity)) continue;
                    TreeSet<EnumFacing> faces = new TreeSet<EnumFacing>(new Comparator<EnumFacing>(){

                        @Override
                        public int compare(EnumFacing o1, EnumFacing o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            int i = -Double.compare(this.getVal(o1), this.getVal(o2));
                            if (i != 0) {
                                return i;
                            }
                            return -o1.compareTo((Enum)o2);
                        }

                        public double getVal(EnumFacing side) {
                            Vec3d vec3d = new Vec3d((Vec3i)tileEntity.func_174877_v());
                            vec3d = VecHelper.addSide(vec3d, side, 0.1);
                            return vec3d.func_72438_d(new Vec3d((Vec3i)TilePowerTransmitter.this.func_174877_v()));
                        }
                    });
                    Collections.addAll(faces, EnumFacing.values());
                    for (EnumFacing facing : faces) {
                        if (!CapGetter.energyReceiver.hasInterface((ICapabilityProvider)tileEntity, facing)) continue;
                        NetworkHandler.sendPacketToPlayer(new PacketParticleSplineCurve(start, new Vec3d((Vec3i)tileEntity.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), startVel, VecHelper.addSide(Vec3d.field_186680_a, facing, 4.0), -65536), playerIn);
                        continue block0;
                    }
                }
            }
            SpecialChat.sendChat(playerIn, (ITextComponent)chat);
        }
        return true;
    }

    public List<BlockPos> refreshTiles() {
        if (!this.isLoaded()) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        IChunkProvider chunkProvider = this.field_145850_b.func_72863_F();
        int minY = this.field_174879_c.func_177956_o() - 4;
        int maxY = this.field_174879_c.func_177956_o() + 4;
        int minX = this.field_174879_c.func_177958_n() - 4;
        int maxX = this.field_174879_c.func_177958_n() + 4;
        int minZ = this.field_174879_c.func_177952_p() - 4;
        int maxZ = this.field_174879_c.func_177952_p() + 4;
        for (int chunkX = minX >> 4; chunkX <= maxX >> 4; ++chunkX) {
            for (int chunkZ = minZ >> 4; chunkZ <= maxZ >> 4; ++chunkZ) {
                Chunk chunk = chunkProvider.func_186026_b(chunkX, chunkZ);
                if (chunk == null) continue;
                for (Map.Entry entry2 : chunk.func_177434_r().entrySet()) {
                    TileEntity tile;
                    BlockPos pos = (BlockPos)entry2.getKey();
                    int y = pos.func_177956_o();
                    if (y < minY || y > maxY || pos.func_177958_n() < minX || pos.func_177958_n() > maxX || pos.func_177952_p() < minZ || pos.func_177952_p() > maxZ || !EnergyTransfer.isValidOutput(tile = (TileEntity)entry2.getValue())) continue;
                    builder.add((Object)pos);
                }
            }
        }
        this.nearbyEnergyTiles = builder.build();
        return this.nearbyEnergyTiles;
    }

    @Override
    public float getPower() {
        return 1.0f;
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    public Collection<ResourceLocation> getTypes() {
        return EnergyTransfer.ENERGY_SYSTEM_TRANSMITTERS;
    }
}

