/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.itemhandler.StackDump;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropAll(World world, BlockPos pos, Iterable<ItemStack> stacks) {
        InventoryHelper.dropAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stacks);
    }

    public static void dropAll(World world, int x, int y, int z, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!StackHelper.isNonNull(stack)) continue;
            InventoryHelper.dropItemStack(world, x, y, z, stack);
        }
    }

    public static void dropItemStack(World worldIn, int x, int y, int z, ItemStack stack) {
        float dx = (float)x + RANDOM.nextFloat() * 0.8f + 0.1f;
        float dy = (float)y + RANDOM.nextFloat() * 0.8f + 0.1f;
        float dz = (float)z + RANDOM.nextFloat() * 0.8f + 0.1f;
        InventoryHelper.dropItemStackAtPosition(worldIn, stack, dx, dy, dz);
    }

    public static void dropItemStackAtPosition(World worldIn, ItemStack stack, double dx, double dy, double dz) {
        EntityItem entityitem = new EntityItem(worldIn, dx, dy, dz, new ItemStack(stack.func_77973_b(), StackHelper.getStacksize(stack), stack.func_77960_j()));
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        entityitem.field_70159_w = RANDOM.nextGaussian() * 0.05;
        entityitem.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
        entityitem.field_70179_y = RANDOM.nextGaussian() * 0.05;
        worldIn.func_72838_d((Entity)entityitem);
    }

    public static int transfer(IItemHandler src, int srcSlot, IItemHandler dest, int maxAmount, boolean allSlots) {
        int i;
        int sent = 0;
        if ((maxAmount = InventoryHelper.getStackLimit(src.extractItem(srcSlot, maxAmount, true))) == 0) {
            return sent;
        }
        int firstEmptySlot = -1;
        for (i = 0; i < dest.getSlots(); ++i) {
            if (StackHelper.isNonNull(dest.getStackInSlot(i))) {
                if (((sent += InventoryHelper.transferSlotAtoSlotB(src, srcSlot, dest, i, maxAmount - sent)) <= 0 || !allSlots) && sent < maxAmount) continue;
                return sent;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot == -1) {
            return sent;
        }
        for (i = firstEmptySlot; i < dest.getSlots(); ++i) {
            if (!StackHelper.isNull(dest.getStackInSlot(i)) || ((sent += InventoryHelper.transferSlotAtoSlotB(src, srcSlot, dest, i, maxAmount - sent)) <= 0 || !allSlots) && sent < maxAmount) continue;
            return sent;
        }
        return sent;
    }

    public static int getStackLimit(ItemStack stack) {
        return StackHelper.isNonNull(stack) ? StackHelper.getStacksize(stack) : 0;
    }

    public static int transferSlotAtoSlotB(IItemHandler handlerA, int slotA, IItemHandler handlerB, int slotB, int maxAmount) {
        ItemStack initExtract = handlerA.extractItem(slotA, maxAmount, true);
        if (StackHelper.isNull(initExtract)) {
            return 0;
        }
        ItemStack initRemainder = handlerB.insertItem(slotB, initExtract, true);
        int i = StackHelper.getStacksize(initExtract) - InventoryHelper.getStackLimit(initRemainder);
        if (i == 0) {
            return 0;
        }
        ItemStack actualExtract = handlerA.extractItem(slotA, i, false);
        handlerB.insertItem(slotB, actualExtract, false);
        return i;
    }

    public static void insertWithRunoff(IItemHandler dest, ItemStack stack, StackDump runoff) {
        if (StackHelper.isNull(stack)) {
            return;
        }
        ItemStack insert = InventoryHelper.insert(dest, stack, false);
        if (StackHelper.isNonNull(insert)) {
            runoff.addStack(insert);
        }
    }

    public static ItemStack insert(IItemHandler handler, ItemStack insert, boolean simulate) {
        ItemStack stackInSlot;
        int i;
        int firstEmptySlot = -1;
        for (i = 0; i < handler.getSlots(); ++i) {
            stackInSlot = handler.getStackInSlot(i);
            if (StackHelper.isNonNull(stackInSlot)) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)insert) || !StackHelper.isNull(insert = handler.insertItem(i, insert, simulate))) continue;
                return StackHelper.empty();
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot == -1) {
            return insert;
        }
        for (i = firstEmptySlot; i < handler.getSlots(); ++i) {
            stackInSlot = handler.getStackInSlot(i);
            if (!StackHelper.isNull(stackInSlot) || !StackHelper.isNull(insert = handler.insertItem(i, insert, simulate))) continue;
            return StackHelper.empty();
        }
        return insert;
    }

    public static int getMaxInsert(IItemHandler handler, ItemStack insert) {
        if (StackHelper.isNull(insert)) {
            return 0;
        }
        int adding = StackHelper.getStacksize(insert);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!StackHelper.isNull(insert = handler.insertItem(i, insert, true))) continue;
            return adding;
        }
        return adding - StackHelper.getStacksize(insert);
    }

    public static IItemHandler copyHandlerWithProperties(final IItemHandler handler) {
        int slots = handler.getSlots();
        ItemStackHandler copy = new ItemStackHandler(slots){
            TIntHashSet dirtySlots;
            {
                super(x0);
                this.dirtySlots = new TIntHashSet();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (simulate && !this.dirtySlots.contains(slot)) {
                    return handler.insertItem(slot, stack, true);
                }
                if (handler.insertItem(slot, stack, true) == stack) {
                    return stack;
                }
                ItemStack item = super.insertItem(slot, stack, simulate);
                if (item != stack) {
                    this.dirtySlots.add(slot);
                }
                return item;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (simulate && !this.dirtySlots.contains(slot)) {
                    return handler.extractItem(slot, amount, true);
                }
                if (StackHelper.isNull(handler.extractItem(slot, amount, true))) {
                    return StackHelper.empty();
                }
                ItemStack item = super.extractItem(slot, amount, simulate);
                if (StackHelper.isNonNull(item)) {
                    this.dirtySlots.add(slot);
                }
                return item;
            }
        };
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (StackHelper.isNonNull(stackInSlot)) {
                stackInSlot = stackInSlot.func_77946_l();
            }
            copy.setStackInSlot(i, stackInSlot);
        }
        return copy;
    }

    public static IItemHandler copyHandler(IItemHandler handler) {
        int slots = handler.getSlots();
        ItemStackHandler copy = new ItemStackHandler(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (StackHelper.isNonNull(stackInSlot)) {
                stackInSlot = stackInSlot.func_77946_l();
            }
            copy.setStackInSlot(i, stackInSlot);
        }
        return copy;
    }

    public static Iterable<ItemStack> getItemHandlerIterator(IItemHandler ... handler) {
        ArrayList<Iterable<ItemStack>> totalList = new ArrayList<Iterable<ItemStack>>(handler.length);
        for (IItemHandler iItemHandler : handler) {
            totalList.add(InventoryHelper.getItemHandlerIterator(iItemHandler));
        }
        return Iterables.concat(totalList);
    }

    public static Iterable<ItemStack> getItemHandlerIterator(final IItemHandler handler) {
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return new Iterator<ItemStack>(){
                    int slot = 0;

                    @Override
                    public boolean hasNext() {
                        return this.slot < handler.getSlots();
                    }

                    @Override
                    public ItemStack next() {
                        return handler.getStackInSlot(this.slot++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

