/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions;

import com.rwtema.extrautils2.compatibility.ChunkProviderFlatCompat;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class WorldWall
extends WorldType {
    public static final String TAG_SPAWN_ITEMS = "xu_wall_spawned";
    public static boolean giveSpawnItems;
    private final AxisAlignedBB BOUNDS = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public WorldWall() {
        super("xu_wall");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getSpawnFuzz(@Nonnull WorldServer world, MinecraftServer server) {
        return 0;
    }

    @Nonnull
    public ChunkProviderFlatCompat getChunkGenerator(@Nonnull World world, String generatorOptions) {
        FlatGeneratorInfo voidGenerator = new FlatGeneratorInfo();
        voidGenerator.func_82647_a(Biome.func_185362_a((Biome)Biomes.field_76772_c));
        voidGenerator.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150350_a));
        voidGenerator.func_82645_d();
        FlatGeneratorInfo altflatgeneratorinfo = new FlatGeneratorInfo();
        altflatgeneratorinfo.func_82647_a(Biome.func_185362_a((Biome)Biomes.field_76772_c));
        altflatgeneratorinfo.func_82650_c().add(new FlatLayerInfo(3, 256, Blocks.field_150357_h, 0));
        altflatgeneratorinfo.func_82645_d();
        final ChunkProviderFlatCompat wallGenerator = new ChunkProviderFlatCompat(world, world.func_72905_C(), false, altflatgeneratorinfo.toString());
        return new ChunkProviderFlatCompat(world, world.func_72905_C(), false, voidGenerator.toString()){

            @Nonnull
            public Chunk func_185932_a(int x, int z) {
                Chunk chunk;
                if (x == -1 || x == -2) {
                    chunk = wallGenerator.func_185932_a(x, z);
                    chunk.func_177446_d(true);
                } else {
                    chunk = super.func_185932_a(x, z);
                    if (x <= 0) {
                        chunk.func_177446_d(true);
                    }
                }
                return chunk;
            }
        };
    }

    @SubscribeEvent
    public void onSpawn(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        if (world.func_175624_G() != this) {
            return;
        }
        BlockPos spawnPoint = new BlockPos(0, 64, 0);
        world.func_175656_a(spawnPoint, Blocks.field_150357_h.func_176223_P());
        for (int i = 1; i <= 3; ++i) {
            world.func_175656_a(spawnPoint.func_177981_b(i), Blocks.field_150350_a.func_176223_P());
        }
        world.func_72912_H().func_176143_a(spawnPoint);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound data;
        World world = event.player.func_130014_f_();
        if (giveSpawnItems && world.func_175624_G() == this && !(data = NBTHelper.getOrCreatePersistentTag(event.player)).func_74767_n(TAG_SPAWN_ITEMS)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack((Block)Blocks.field_150349_c, 16));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack(Blocks.field_150345_g, 1, 0));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack(Items.field_151100_aR, 64, EnumDyeColor.WHITE.func_176767_b()));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack(Items.field_151129_at));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack(Blocks.field_150432_aD));
            data.func_74757_a(TAG_SPAWN_ITEMS, true);
        }
    }

    @SubscribeEvent
    public void onPlayerTeleport(EnderTeleportEvent event) {
        if (event.getTargetX() < 0.0) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            if (entityLiving.field_70170_p.func_175624_G() == this && entityLiving.field_70165_t >= event.getTargetX()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTransport(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.toDim != 0) {
            return;
        }
        World world = event.player.field_70170_p;
        if (world.func_175624_G() != this) {
            return;
        }
        if (event.player.field_70165_t >= 0.0) {
            return;
        }
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            player.field_71135_a.func_147364_a(0.5, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        }
    }

    @SubscribeEvent
    public void onCollision(GetCollisionBoxesEvent event) {
        if (event.getWorld().func_175624_G() != this) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        AxisAlignedBB aabb = event.getAabb();
        if (this.BOUNDS.func_72326_a(aabb)) {
            event.getCollisionBoxesList().add(this.BOUNDS);
            for (int i = -1; i <= 2; ++i) {
                AxisAlignedBB bb;
                int x2 = (int)Math.ceil(aabb.field_72340_a) - i;
                if (x2 >= 0 || !(bb = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, (double)x2, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)).func_72326_a(aabb)) continue;
                event.getCollisionBoxesList().add(bb);
            }
        }
    }
}

