/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class XUBlockState
extends BlockStateContainer.StateImplementation
implements IExtendedBlockState {
    @SideOnly(value=Side.CLIENT)
    public ThreadLocal<MutableModel> result;
    public int metadata;
    public int dropMeta;
    public String dropName;
    public String unlocalizedName;
    @Nullable
    private IBlockState clean;

    public XUBlockState(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn) {
        super(blockIn, propertiesIn);
    }

    private static <T extends Comparable<T>> IBlockState withDefaultMetaProperty(IBlockState base, IMetaProperty<T> property) {
        return base.func_177226_a(property, property.getDefaultValue());
    }

    public void func_177235_a(Map<Map<IProperty<?>, Comparable<?>>, BlockStateContainer.StateImplementation> map) {
        super.func_177235_a(map);
        this.clean = null;
    }

    public String getUnlocalizedName() {
        if (this.unlocalizedName == null) {
            this.unlocalizedName = StringUtils.func_151246_b((String)this.dropName) ? this.func_177230_c().func_149739_a() + ".name" : this.func_177230_c().func_149739_a() + "." + this.dropName + ".name";
        }
        return this.unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void load(BoxModel model) {
        if (this.result == null) {
            this.result = ThreadLocal.withInitial(() -> new MutableModel(Transforms.blockTransforms));
        }
        model.loadIntoMutable(this.result.get(), MinecraftForgeClient.getRenderLayer());
    }

    public void clearPropertyTable() {
        this.field_177238_c = null;
    }

    public Collection<IUnlistedProperty<?>> getUnlistedNames() {
        return ImmutableList.of();
    }

    public <V> V getValue(IUnlistedProperty<V> property) {
        throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
    }

    public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
        throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
    }

    public ImmutableMap getUnlistedProperties() {
        return ImmutableMap.of();
    }

    @Nonnull
    public IBlockState getClean() {
        Object clean = this.clean;
        if (clean == null) {
            clean = this;
            for (Map.Entry entry2 : this.func_177228_b().entrySet()) {
                if (!(entry2.getKey() instanceof IMetaProperty)) continue;
                IMetaProperty metaProperty = (IMetaProperty)entry2.getKey();
                clean = XUBlockState.withDefaultMetaProperty(clean, metaProperty);
            }
            this.clean = clean;
        }
        return clean;
    }
}

