/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.resonator;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public interface IResonatorRecipe {
    public List<ItemStack> getInputs();

    public ItemStack getOutput();

    public int getEnergy();

    default public ItemStack getOutput(ItemStack input) {
        return this.getOutput();
    }

    default public boolean matches(ItemStack input) {
        for (ItemStack target : this.getInputs()) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    default public int getNumberOfInputsToConsume(ItemStack input) {
        return 1;
    }

    default public int getEnergy(ItemStack input) {
        return this.getEnergy();
    }

    default public boolean shouldAddOwnerTag() {
        return false;
    }

    default public boolean shouldProgress(TileEntity resonator, int frequency, ItemStack input) {
        return true;
    }

    default public String getRequirementText() {
        return "";
    }
}

