/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodchest;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairAction;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.AnvilRepairAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;

public class BloodChestRepairActionRegistry
implements IBloodChestRepairActionRegistry {
    private String[] itemBlacklist = new String[0];
    private final List<IBloodChestRepairAction> repairActions = new LinkedList<IBloodChestRepairAction>();

    public BloodChestRepairActionRegistry() {
        this.register(new DamageableItemRepairAction());
        this.register(new AnvilRepairAction());
    }

    @Override
    public void register(IBloodChestRepairAction repairAction) {
        this.repairActions.add(repairAction);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack itemStack) {
        if (this.isNotBlacklisted(itemStack)) {
            for (IBloodChestRepairAction action : this.repairActions) {
                if (!action.isItemValidForSlot(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int canRepair(ItemStack itemStack, int tick) {
        for (int i = 0; i < this.repairActions.size(); ++i) {
            if (!this.repairActions.get(i).canRepair(itemStack, tick)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public float repair(ItemStack itemStack, Random random, int actionID, boolean doAction, boolean isBulk) {
        return this.repairActions.get(actionID).repair(itemStack, random, doAction, isBulk);
    }

    protected boolean isNotBlacklisted(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (String name : this.itemBlacklist) {
            if (!((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b())).toString().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setBlacklist(String[] blacklist) {
        this.itemBlacklist = blacklist;
    }

    public static class ItemBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        public void onChanged(Object value) {
            if (calledOnce) {
                ((IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class)).setBlacklist((String[])value);
            }
            calledOnce = true;
        }

        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

