/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyInTankTickAction;

public class EmptyFluidContainerInTankTickAction<T extends TickingTankInventoryTileEntity<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        FluidActionResult result;
        ItemStack containerStack = tile.getInventory().func_70301_a(slot).func_77946_l();
        IFluidHandlerItem container = FluidUtil.getFluidHandler((ItemStack)containerStack);
        if (container != null && FluidHelpers.hasFluid((IFluidHandler)container) && (result = FluidUtil.tryEmptyContainer((ItemStack)containerStack, (IFluidHandler)tile.getTank(), (int)MB_PER_TICK, null, (boolean)false).isSuccess() ? FluidUtil.tryEmptyContainer((ItemStack)containerStack.func_77979_a(1), (IFluidHandler)tile.getTank(), (int)MB_PER_TICK, null, (boolean)true) : FluidUtil.tryEmptyContainer((ItemStack)containerStack.func_77979_a(1), (IFluidHandler)tile.getTank(), (int)1000, null, (boolean)true)).isSuccess()) {
            ItemStack resultStack = result.getResult();
            if (resultStack.func_190916_E() == 0) {
                resultStack = containerStack;
                if (resultStack.func_190916_E() == 0) {
                    resultStack = ItemStack.field_190927_a;
                }
            } else if (containerStack.func_190916_E() > 0) {
                MinecraftHelpers.dropItems((World)tile.func_145831_w(), (ItemStack)resultStack.func_77946_l(), (BlockPos)tile.func_174877_v());
                resultStack = containerStack;
            }
            tile.getInventory().func_70299_a(slot, resultStack);
        }
    }

    @Override
    public float getRequiredTicks(T tile, int slot, int tick) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, tile.getInventory().func_70301_a(slot));
    }

    public static int getRequiredTicks(TankInventoryTileEntity tile, ItemStack itemStack) {
        IFluidHandlerItem container = FluidUtil.getFluidHandler((ItemStack)itemStack);
        int amount = 0;
        if (FluidHelpers.hasFluid((IFluidHandler)container)) {
            amount = FluidHelpers.getAmount((FluidStack)FluidHelpers.getFluid((IFluidHandler)container));
        }
        int capacity = Math.min(FluidHelpers.getCapacity((IFluidHandler)container), tile.getTank().getFluidAmount());
        return (capacity - amount) / MB_PER_TICK;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        boolean emptyContainer = false;
        ItemStack containerStack = tile.getInventory().func_70301_a(slot);
        IFluidHandlerItem container = FluidUtil.getFluidHandler((ItemStack)containerStack);
        if (container != null && FluidHelpers.hasFluid((IFluidHandler)container)) {
            FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)container);
            if (FluidHelpers.getAmount((FluidStack)fluidStack) <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

