/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;
import org.cyclops.evilcraft.item.Mace;

public class MaceOfDistortion
extends Mace {
    private static MaceOfDistortion _instance = null;
    public static final int AOE_TICK_UPDATE = 20;
    private static final int MAXIMUM_CHARGE = 100;
    private static final float MELEE_DAMAGE = 7.0f;
    private static final float RADIAL_DAMAGE = 3.0f;
    private static final int CONTAINER_SIZE = 4000;
    private static final int HIT_USAGE = 5;
    private static final int POWER_LEVELS = 5;

    public static MaceOfDistortion getInstance() {
        return _instance;
    }

    public MaceOfDistortion(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 4000, 5, 100, 5, 7.0f);
    }

    protected void distortEntities(World world, EntityLivingBase initiator, int itemUsedCount, int power) {
        double x = initiator.field_70165_t;
        double y = initiator.field_70163_u;
        double z = initiator.field_70161_v;
        double area = this.getArea(itemUsedCount);
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g(area);
        List entities = world.func_72839_b((Entity)initiator, box);
        boolean onePlayer = false;
        for (Entity entity : entities) {
            if (entity instanceof EntityPlayer) {
                onePlayer = true;
            }
            this.distortEntity(world, initiator, entity, x, y, z, itemUsedCount, power);
        }
        if (initiator instanceof EntityPlayerMP) {
            Advancements.DISTORT.trigger((EntityPlayerMP)initiator, entities);
        }
    }

    public void distortEntity(World world, EntityLivingBase initiator, Entity entity, double x, double y, double z, int itemUsedCount, int power) {
        double dz;
        double inverseStrength = entity.func_70011_f(x, y, z) / (double)(itemUsedCount + 1);
        double knock = (double)(power + itemUsedCount / 200) + 1.0;
        double dx = entity.field_70165_t - x;
        double dy = entity.field_70163_u + (double)entity.func_70047_e() - y;
        double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + (dz = entity.field_70161_v - z) * dz));
        if (d != 0.0) {
            dx /= d;
            dy /= d;
            dz /= d;
            double strength = (1.0 - inverseStrength) * knock;
            if (entity instanceof EntityLivingBase) {
                ExtendedDamageSource damageSource = initiator == null ? ExtendedDamageSource.distorted : (initiator instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)initiator)) : DamageSource.func_76358_a((EntityLivingBase)initiator));
                entity.func_70097_a((DamageSource)damageSource, 3.0f * (float)power);
                if (world.field_72995_K) {
                    MaceOfDistortion.showEntityDistored(world, initiator, entity, power);
                }
            }
            if (entity instanceof VengeanceSpirit) {
                ((VengeanceSpirit)entity).setSwarm(true);
            }
            entity.field_70159_w += dx * (strength /= 2.0);
            entity.field_70181_x += dy * strength;
            entity.field_70179_y += dz * strength;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void showEntityDistored(World world, EntityLivingBase initiator, Entity entity, int power) {
        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (initiator != null) {
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, entity.field_70165_t, entity.field_70163_u + (double)field_77697_d.nextFloat(), entity.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    protected void animateOutOfEnergy(World world, EntityPlayer player) {
        double xCoord = player.field_70165_t;
        double yCoord = player.field_70163_u;
        double zCoord = player.field_70161_v;
        float particleMotionX = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(new ParticleSmokeNormal.Factory().func_178902_a(0, world, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ, new int[0]));
        world.func_184148_a(player, xCoord, yCoord, zCoord, SoundEvents.field_187676_dE, SoundCategory.RECORDS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public int func_77619_b() {
        return 15;
    }

    @Override
    public Multimap getAttributeModifiers(EntityEquipmentSlot slot, ItemStack itemStack) {
        Multimap multimap = super.getAttributeModifiers(slot, itemStack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 7.0, 0));
        }
        return multimap;
    }

    @Override
    protected void use(World world, EntityLivingBase entity, int itemUsedCount, int power) {
        this.distortEntities(world, entity, itemUsedCount, power);
    }
}

