/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class ResourceUtils {
    public static InputStream getResourceAsStream(ResourceLocation resource) throws IOException {
        return ResourceUtils.getResource(resource).func_110527_b();
    }

    public static IReloadableResourceManager getResourceManager() {
        return (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
    }

    public static IResource getResource(String location) throws IOException {
        return ResourceUtils.getResource(new ResourceLocation(location));
    }

    public static IResource getResource(ResourceLocation location) throws IOException {
        return ResourceUtils.getResourceManager().func_110536_a(location);
    }

    public static void registerReloadListener(IResourceManagerReloadListener reloadListener) {
        ResourceUtils.getResourceManager().func_110542_a(reloadListener);
    }

    @Deprecated
    public static void tryCreateFile(File file) {
        if (!file.getParentFile().exists()) {
            ResourceUtils.tryCreateDirectory(file.getParentFile());
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new Exception("createNewFile returned false.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create file: " + file.getAbsolutePath(), e);
            }
        }
    }

    public static File ensureExists(File file) {
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error whilst creating file!", e);
            }
        }
        return file;
    }

    @Deprecated
    public static void tryCreateDirectory(File dir) {
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    throw new Exception("mkdirs returned false.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create directory: " + dir.getAbsolutePath(), e);
            }
        }
    }
}

