/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.util.VectorUtils;

public class SideAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = new AttributeKey<int[]>(){

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }
    };
    private int[] sideRef;

    @Override
    public int[] newArray(int length) {
        return new int[length];
    }

    @Override
    public String getAttribName() {
        return "sideAttrib";
    }

    @Override
    public boolean load(CCRenderState state) {
        this.sideRef = state.model.getAttributes(attributeKey);
        if (state.model.hasAttribute(attributeKey)) {
            return this.sideRef != null;
        }
        state.pipeline.addDependency(state.normalAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState state) {
        state.side = this.sideRef != null ? this.sideRef[state.vertexIndex] : VectorUtils.findSide(state.normal);
    }
}

