/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataUtils;
import codechicken.lib.vec.Vector3;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public interface MCDataOutput {
    public MCDataOutput writeLong(long var1);

    public MCDataOutput writeInt(int var1);

    public MCDataOutput writeShort(int var1);

    public MCDataOutput writeByte(int var1);

    public MCDataOutput writeDouble(double var1);

    public MCDataOutput writeFloat(float var1);

    public MCDataOutput writeBoolean(boolean var1);

    public MCDataOutput writeChar(char var1);

    default public MCDataOutput writeVarInt(int i) {
        MCDataUtils.writeVarInt(this, i);
        return this;
    }

    default public MCDataOutput writeVarShort(int s) {
        MCDataUtils.writeVarShort(this, s);
        return this;
    }

    default public MCDataOutput writeVarLong(long l) {
        MCDataUtils.writeVarLong(this, l);
        return this;
    }

    public MCDataOutput writeArray(byte[] var1);

    default public MCDataOutput writeString(String s) {
        MCDataUtils.writeString(this, s);
        return this;
    }

    default public MCDataOutput writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    default public MCDataOutput writeEnum(Enum<?> value) {
        this.writeVarInt(value.ordinal());
        return this;
    }

    default public MCDataOutput writeResourceLocation(ResourceLocation location) {
        this.writeString(location.toString());
        return this;
    }

    default public MCDataOutput writePos(BlockPos pos) {
        this.writeInt(pos.func_177958_n());
        this.writeInt(pos.func_177956_o());
        this.writeInt(pos.func_177952_p());
        return this;
    }

    default public MCDataOutput writeVector(Vector3 vec) {
        this.writeDouble(vec.x);
        this.writeDouble(vec.y);
        this.writeDouble(vec.z);
        return this;
    }

    default public MCDataOutput writeNBTTagCompound(NBTTagCompound tag) {
        MCDataUtils.writeNBTTagCompount(this, tag);
        return this;
    }

    default public MCDataOutput writeItemStack(ItemStack stack) {
        MCDataUtils.writeItemStack(this, stack);
        return this;
    }

    default public MCDataOutput writeFluidStack(FluidStack liquid) {
        MCDataUtils.writeFluidStack(this, liquid);
        return this;
    }
}

