/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUtils {
    public static IFluidHandler getFluidHandler(TileEntity te, EnumFacing facing) {
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
        return null;
    }

    public static int fill(TileEntity te, FluidStack fluid, int fluidVolume, EnumFacing facing) {
        return FluidUtils.getFluidHandler(te, facing).fill(fluid, true);
    }

    public static int testFill(TileEntity te, FluidStack fluid, int fluidVolume, EnumFacing facing) {
        return FluidUtils.getFluidHandler(te, facing).fill(fluid, false);
    }

    public static FluidStack drain(TileEntity te, int fluidVolume, EnumFacing facing) {
        return FluidUtils.getFluidHandler(te, facing).drain(fluidVolume, true);
    }

    public static FluidStack testDrain(TileEntity te, int fluidVolume, EnumFacing facing) {
        return FluidUtils.getFluidHandler(te, facing).drain(fluidVolume, false);
    }

    public static boolean hasRoomForFluid(TileEntity te, FluidStack fluid, EnumFacing facing) {
        IFluidHandler handler = FluidUtils.getFluidHandler(te, facing);
        if (handler != null) {
            return FluidUtils.hasRoomForFluid(handler, fluid);
        }
        return false;
    }

    public static boolean hasRoomForFluid(IFluidHandler handler, FluidStack fluid) {
        return FluidUtils.getAvailableVolumeForFluid(handler, fluid) > 0;
    }

    public static boolean isFluidApplicable(IFluidHandler handler, FluidStack fluid) {
        for (IFluidTankProperties property : handler.getTankProperties()) {
            if (!property.canFillFluidType(fluid)) continue;
            return true;
        }
        return false;
    }

    public static int getTotalVolume(IFluidHandler handler) {
        int totalVolume = 0;
        for (IFluidTankProperties property : handler.getTankProperties()) {
            totalVolume += property.getCapacity();
        }
        return totalVolume;
    }

    public static int getAvailableVolume(IFluidHandler handler) {
        int availableVolume = 0;
        for (IFluidTankProperties property : handler.getTankProperties()) {
            availableVolume += property.getContents().amount;
        }
        return FluidUtils.getTotalVolume(handler) - availableVolume;
    }

    public static int getTotalVolumeForFluid(IFluidHandler handler, FluidStack fluid) {
        int totalVolume = 0;
        for (IFluidTankProperties property : handler.getTankProperties()) {
            if (property.getCapacity() > 0 && property.getContents() == null) {
                totalVolume += property.getCapacity();
                continue;
            }
            if (!property.getContents().isFluidEqual(fluid)) continue;
            totalVolume += property.getCapacity();
        }
        return totalVolume;
    }

    public static int getAvailableVolumeForFluid(IFluidHandler handler, FluidStack fluid) {
        int availableVolume = 0;
        if (fluid != null && FluidUtils.isFluidApplicable(handler, fluid)) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                if (property.getCapacity() > 0 && property.getContents() == null) {
                    availableVolume += property.getCapacity();
                    continue;
                }
                if (!property.getContents().isFluidEqual(fluid)) continue;
                availableVolume += FluidUtils.getTotalVolumeForFluid(handler, fluid) - property.getContents().amount;
            }
        }
        return availableVolume;
    }
}

