/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.ore;

import io.github.phantamanta44.mekores.constant.LangConst;
import io.github.phantamanta44.mekores.ore.OreType;
import io.github.phantamanta44.mekores.util.OreDictHelper;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public enum OreStage {
    CRYSTAL("crystal"),
    SHARD("shard"),
    CLUMP("clump"),
    DIRTY_DUST("dustDirty"),
    DUST("dust");

    public final String prefix;

    private OreStage(String prefix) {
        this.prefix = prefix;
    }

    public String getEntry(String ore) {
        return this.prefix + ore;
    }

    @Nullable
    public ItemStack getOre(String ore, int qty) {
        return OreDictHelper.getStack(this.getEntry(ore), qty);
    }

    public ItemStack oreForType(OreType type, int qty) {
        return Objects.requireNonNull(this.getOre(type.key, qty));
    }

    public OreStage next() {
        return OreStage.values()[this.ordinal() + 1];
    }

    public boolean exists(OreType type) {
        return OreDictHelper.exists(this.getEntry(type.key));
    }

    public String getLocalizedName(OreType type) {
        return LangConst.get("item.mekores:" + this.prefix + ".name", type.getLocalizedName());
    }
}

