/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.item;

import io.github.phantamanta44.mekores.CommonProxy;
import io.github.phantamanta44.mekores.MekOres;
import io.github.phantamanta44.mekores.item.MOItems;
import io.github.phantamanta44.mekores.item.base.ItemModSubs;
import io.github.phantamanta44.mekores.ore.OreStage;
import io.github.phantamanta44.mekores.ore.OreType;
import io.github.phantamanta44.mekores.ore.SpecificOreStage;
import io.github.phantamanta44.mekores.util.GasHelper;
import io.github.phantamanta44.mekores.util.IMCHelper;
import io.github.phantamanta44.mekores.util.OreDictHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMekanismOre
extends ItemModSubs {
    private static final String[] VANILLA_ORE_NAMES = new String[]{"Iron", "Gold", "Osmium", "Copper", "Tin", "Silver", "Lead"};
    private static SpecificOreStage[] registry;

    public static SpecificOreStage getStage(ItemStack stack) {
        return registry[stack.func_77960_j()];
    }

    private static int buildRegistry() {
        registry = (SpecificOreStage[])Arrays.stream(OreType.values()).peek(GasHelper::registerOreGas).flatMap(t -> Arrays.stream(OreStage.values()).map(s -> new SpecificOreStage((OreType)((Object)t), (OreStage)((Object)((Object)s))))).toArray(SpecificOreStage[]::new);
        return registry.length;
    }

    ItemMekanismOre() {
        super("mekanismOre", ItemMekanismOre.buildRegistry());
        block7: for (int i = 0; i < registry.length; ++i) {
            SpecificOreStage stage = registry[i];
            switch (stage.stage) {
                case CRYSTAL: {
                    MekOres.PROXY.registerItemModel(this, i, "crystal");
                    continue block7;
                }
                case SHARD: {
                    MekOres.PROXY.registerItemModel(this, i, "shard");
                    continue block7;
                }
                case CLUMP: {
                    MekOres.PROXY.registerItemModel(this, i, "clump");
                    continue block7;
                }
                case DIRTY_DUST: {
                    MekOres.PROXY.registerItemModel(this, i, "dirty_dust");
                    continue block7;
                }
                case DUST: {
                    MekOres.PROXY.registerItemModel(this, i, "dust");
                }
            }
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == MOItems.CREATIVE_TAB) {
            for (int i = 0; i < this.subs; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                if (!ItemMekanismOre.getStage(stack).isValid()) continue;
                subItems.add((Object)stack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return ItemMekanismOre.getStage(stack).getLocalizedName();
    }

    public void registerOreDict() {
        for (int i = 0; i < registry.length; ++i) {
            ItemStack stack = new ItemStack((Item)this, 1, i);
            SpecificOreStage stage = ItemMekanismOre.getStage(stack);
            if (!stage.isValid()) continue;
            OreDictionary.registerOre((String)stage.getEntry(), (ItemStack)stack);
        }
    }

    public void registerRecipes() {
        Gas hCl = GasRegistry.getGas((String)"hydrogenchloride");
        Gas oxygen = GasRegistry.getGas((String)"oxygen");
        for (OreType oreType : OreType.values()) {
            if (!oreType.isValid()) continue;
            try {
                ItemStack ingotStack;
                MekOres.LOGGER.debug("Adding ore recipes for {}", (Object)oreType.key);
                NonNullList ores = OreDictionary.getOres((String)("ore" + oreType.key), (boolean)false);
                for (ItemStack stack : ores) {
                    IMCHelper.addChemicalDissolutionRecipe(stack, GasHelper.gasStack(oreType.getName(), 1000));
                }
                IMCHelper.addChemicalWasherRecipe(GasHelper.gasStack(oreType.getName(), 1), GasHelper.gasStack("clean" + oreType.getName(), 1));
                IMCHelper.addChemicalCrystalizationRecipe(GasHelper.gasStack("clean" + oreType.getName(), 200), OreStage.CRYSTAL.oreForType(oreType, 1));
                IMCHelper.addChemicalInjectionRecipe(OreStage.CRYSTAL.oreForType(oreType, 1), hCl, OreStage.SHARD.oreForType(oreType, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addChemicalInjectionRecipe(stack, hCl, OreStage.SHARD.oreForType(oreType, 4));
                }
                IMCHelper.addPurificationRecipe(OreStage.SHARD.oreForType(oreType, 1), oxygen, OreStage.CLUMP.oreForType(oreType, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addPurificationRecipe(stack, oxygen, OreStage.CLUMP.oreForType(oreType, 3));
                }
                IMCHelper.addCrusherRecipe(OreStage.CLUMP.oreForType(oreType, 1), OreStage.DIRTY_DUST.oreForType(oreType, 1));
                IMCHelper.addEnrichmentRecipe(OreStage.DIRTY_DUST.oreForType(oreType, 1), OreStage.DUST.oreForType(oreType, 1));
                for (ItemStack stack : ores) {
                    IMCHelper.addEnrichmentRecipe(stack, OreStage.DUST.oreForType(oreType, 2));
                }
                NonNullList dusts = OreDictionary.getOres((String)OreStage.DUST.getEntry(oreType.key), (boolean)false);
                if (dusts.stream().allMatch(is -> is.func_77973_b() instanceof ItemMekanismOre) && (ingotStack = OreDictHelper.getStack("ingot" + oreType.key, 1)) != null) {
                    GameRegistry.addSmelting((ItemStack)OreStage.DUST.oreForType(oreType, 1), (ItemStack)ingotStack, (float)0.0f);
                }
                ores.stream().findAny().ifPresent(arg_0 -> ItemMekanismOre.lambda$registerRecipes$4((List)dusts, arg_0));
                if (CommonProxy.CONFIG.oreNetherMultiplier != 0) {
                    try {
                        NonNullList netherOres = OreDictionary.getOres((String)("oreNether" + oreType.key), (boolean)false);
                        if (!netherOres.isEmpty()) {
                            MekOres.LOGGER.debug("Adding nether ore recipes for {}", (Object)oreType.key);
                            ItemMekanismOre.registerMultRecipes(oreType, (List<ItemStack>)netherOres, CommonProxy.CONFIG.oreNetherMultiplier, hCl, oxygen);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to register nether ore recipes for ore: " + (Object)((Object)oreType), e);
                    }
                }
                if (CommonProxy.CONFIG.oreEndMultiplier == 0) continue;
                try {
                    NonNullList endOres = OreDictionary.getOres((String)("oreEnd" + oreType.key), (boolean)false);
                    if (endOres.isEmpty()) continue;
                    MekOres.LOGGER.debug("Adding end ore recipes for {}", (Object)oreType.key);
                    ItemMekanismOre.registerMultRecipes(oreType, (List<ItemStack>)endOres, CommonProxy.CONFIG.oreEndMultiplier, hCl, oxygen);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to register end ore recipes for ore: " + (Object)((Object)oreType), e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register recipes for ore: " + (Object)((Object)oreType), e);
            }
        }
        if (CommonProxy.CONFIG.oreNetherMultiplier != 0) {
            for (String string : VANILLA_ORE_NAMES) {
                try {
                    MekOres.LOGGER.debug("Adding nether ore recipes for {}", (Object)string);
                    ItemMekanismOre.registerMultRecipes("oreNether", string, CommonProxy.CONFIG.oreNetherMultiplier, hCl, oxygen);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to register nether ore recipes for ore: " + string, e);
                }
            }
        }
        if (CommonProxy.CONFIG.oreEndMultiplier != 0) {
            for (String string : VANILLA_ORE_NAMES) {
                try {
                    MekOres.LOGGER.debug("Adding end ore recipes for {}", (Object)string);
                    ItemMekanismOre.registerMultRecipes("oreEnd", string, CommonProxy.CONFIG.oreEndMultiplier, hCl, oxygen);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to register end ore recipes for ore: " + string, e);
                }
            }
        }
    }

    private static void registerMultRecipes(OreType type, List<ItemStack> ores, int mult, Gas hCl, Gas oxygen) {
        ItemMekanismOre.registerMultRecipes(type.getName(), type.key, ores, mult, hCl, oxygen);
    }

    private static void registerMultRecipes(String prefix, String name, int mult, Gas hCl, Gas oxygen) {
        ItemMekanismOre.registerMultRecipes(name.toLowerCase(), name, (List<ItemStack>)OreDictionary.getOres((String)(prefix + name), (boolean)false), mult, hCl, oxygen);
    }

    private static void registerMultRecipes(String gasName, String key, List<ItemStack> ores, int mult, Gas hCl, Gas oxygen) {
        for (ItemStack stack : ores) {
            IMCHelper.addChemicalDissolutionRecipe(stack, GasHelper.gasStack(gasName, 1000 * mult));
        }
        for (ItemStack stack : ores) {
            IMCHelper.addChemicalInjectionRecipe(stack, hCl, Objects.requireNonNull(OreStage.SHARD.getOre(key, 4 * mult)));
        }
        for (ItemStack stack : ores) {
            IMCHelper.addPurificationRecipe(stack, oxygen, Objects.requireNonNull(OreStage.CLUMP.getOre(key, 3 * mult)));
        }
        for (ItemStack stack : ores) {
            IMCHelper.addEnrichmentRecipe(stack, Objects.requireNonNull(OreStage.DUST.getOre(key, 2 * mult)));
        }
    }

    private static /* synthetic */ void lambda$registerRecipes$4(List dusts, ItemStack oreStack) {
        ItemStack cobble = new ItemStack(Blocks.field_150347_e, 1);
        for (ItemStack dust : dusts) {
            IMCHelper.addCombiningRecipe(ItemHandlerHelper.copyStackWithSize((ItemStack)dust, (int)8), cobble, oreStack);
        }
    }
}

