/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui;

import aroma1997.core.client.gui.IRenderTexture;
import aroma1997.core.client.gui.IRenderable;
import aroma1997.core.client.gui.RenderTexture;
import java.util.function.DoubleSupplier;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum DynamicTexture {
    ENERGY(new RenderTexture(0, 0, 16, 64, RenderTexture.GUI_SPECIALS), new RenderTexture(16, 0, 16, 64, RenderTexture.GUI_SPECIALS), Direction.UP),
    PROGRESS_ARROW(new RenderTexture(32, 0, 22, 15, RenderTexture.GUI_SPECIALS), new RenderTexture(32, 15, 22, 15, RenderTexture.GUI_SPECIALS), Direction.RIGHT);

    private final IRenderTexture background;
    private final IRenderTexture overlay;
    private final Direction dir;

    private DynamicTexture(IRenderTexture background, IRenderTexture overlay, Direction dir) {
        this.background = background;
        this.overlay = overlay;
        this.dir = dir;
    }

    public IRenderTexture getBackground() {
        return this.background;
    }

    public IRenderable getRenderable(final DoubleSupplier progress) {
        return new IRenderable(){

            @Override
            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                DynamicTexture.this.background.render(x, y, gui, textureManager);
                double actualProgress = Math.min(Math.max(progress.getAsDouble(), 0.0), 1.0);
                int width = DynamicTexture.this.overlay.getWidth();
                int height = DynamicTexture.this.overlay.getHeight();
                if (DynamicTexture.this.dir.horizontal()) {
                    width = (int)((double)width * actualProgress);
                } else {
                    height = (int)((double)height * actualProgress);
                }
                int startXOffset = 0;
                int startYOffset = 0;
                if (!DynamicTexture.this.dir.doesGrowTowardsPositive()) {
                    startXOffset = DynamicTexture.this.overlay.getWidth() - width;
                    startYOffset = DynamicTexture.this.overlay.getHeight() - height;
                }
                gui.func_73729_b(x + startXOffset, y + startYOffset, startXOffset + DynamicTexture.this.overlay.getU(), startYOffset + DynamicTexture.this.overlay.getV(), width, height);
            }
        };
    }

    private static enum Direction {
        DOWN,
        UP,
        RIGHT,
        LEFT;


        public boolean doesGrowTowardsPositive() {
            return (this.ordinal() & 1) == 0;
        }

        public boolean horizontal() {
            return (this.ordinal() & 2) != 0;
        }
    }
}

