/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block.te.element;

import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.element.TileEntityElementBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidElement
extends TileEntityElementBase {
    private final List<TankInfo> fluidTanks = new ArrayList<TankInfo>();
    private final IFluidHandler[] handlers = new IFluidHandler[EnumFacing.field_82609_l.length + 1];

    public FluidElement(TileEntityBase parent) {
        super(parent);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        NBTTagCompound tanks = nbt.func_74775_l("tanks");
        for (TankInfo info : this.fluidTanks) {
            IFluidTank tank = (IFluidTank)info.tank.get();
            if (!info.isManaged || !(tank instanceof FluidTank)) continue;
            FluidTank ftank = (FluidTank)tank;
            if (tanks.func_150297_b(info.name, 10)) {
                ftank.readFromNBT(tanks.func_74775_l(info.name));
                continue;
            }
            ftank.setFluid(null);
        }
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        nbt = super.writeToNbt(nbt);
        NBTTagCompound tanks = new NBTTagCompound();
        nbt.func_74782_a("tanks", (NBTBase)tanks);
        for (TankInfo info : this.fluidTanks) {
            IFluidTank tank = (IFluidTank)info.tank.get();
            if (!info.isManaged || !(tank instanceof FluidTank)) continue;
            FluidTank ftank = (FluidTank)tank;
            NBTTagCompound current = ftank.writeToNBT(new NBTTagCompound());
            tanks.func_74782_a(info.name, (NBTBase)current);
        }
        return nbt;
    }

    @Override
    public Collection<? extends Capability<?>> getProvidedCapabilities(EnumFacing side) {
        return Collections.singleton(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getFluidHandler(side);
        }
        return super.getCapability(cap, side);
    }

    public IFluidHandler getFluidHandler(EnumFacing side) {
        int idx = side == null ? this.handlers.length - 1 : side.ordinal();
        if (this.handlers[idx] == null) {
            this.handlers[idx] = new FluidHandler(side);
        }
        return this.handlers[idx];
    }

    private void addTank(TankInfo info) {
        assert (this.fluidTanks.stream().map(i -> ((TankInfo)i).name).noneMatch(info.name::equals));
        this.fluidTanks.add(info);
    }

    public <T extends FluidTank> T addManagedTank(String name, T tank) {
        return this.addManagedTank(name, tank, (EnumFacing side) -> true);
    }

    public <T extends FluidTank> T addManagedTank(String name, T tank, EnumFacing ... acceptedSides) {
        EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);
        sides.addAll(Arrays.asList(acceptedSides));
        return this.addManagedTank(name, tank, sides);
    }

    public <T extends FluidTank> T addManagedTank(String name, T tank, Set<EnumFacing> sides) {
        return this.addManagedTank(name, tank, sides::contains);
    }

    public <T extends FluidTank> T addManagedTank(String name, T tank, Predicate<EnumFacing> acceptedSides) {
        this.addTank(new TankInfo(name, () -> tank, acceptedSides, true));
        tank.setTileEntity((TileEntity)this.getParent());
        return tank;
    }

    public void addUnmanagedTank(String name, Supplier<IFluidTank> tank, Predicate<EnumFacing> sides) {
        this.addTank(new TankInfo(name, tank, sides, false));
    }

    public IFluidTank getFluidTank(String name) {
        for (TankInfo info : this.fluidTanks) {
            if (!name.equals(info.name)) continue;
            return (IFluidTank)info.tank.get();
        }
        return null;
    }

    private class TankInfo {
        private final String name;
        private final Supplier<IFluidTank> tank;
        private final Predicate<EnumFacing> acceptedSides;
        private final boolean isManaged;

        public TankInfo(String name, Supplier<IFluidTank> tank, Predicate<EnumFacing> acceptedSides, boolean isManaged) {
            this.name = name;
            this.tank = tank;
            this.acceptedSides = acceptedSides;
            this.isManaged = isManaged;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private final EnumFacing side;

        public FluidHandler(EnumFacing side) {
            this.side = side;
        }

        private Stream<IFluidTank> getApplicableTanks() {
            return FluidElement.this.fluidTanks.stream().filter(info -> ((TankInfo)info).acceptedSides.test(this.side)).map(info -> (IFluidTank)((TankInfo)info).tank.get()).filter(Objects::nonNull);
        }

        public IFluidTankProperties[] getTankProperties() {
            return FluidTankProperties.convert((FluidTankInfo[])((FluidTankInfo[])this.getApplicableTanks().map(IFluidTank::getInfo).toArray(FluidTankInfo[]::new)));
        }

        public int fill(FluidStack resource, boolean doFill) {
            int amount;
            FluidStack fill;
            IFluidTank tank;
            if (resource == null) {
                return 0;
            }
            Iterator iter = this.getApplicableTanks().iterator();
            for (amount = resource.amount; iter.hasNext() && amount > 0; amount -= tank.fill(fill, doFill)) {
                tank = (IFluidTank)iter.next();
                fill = resource.copy();
                fill.amount = amount;
            }
            return resource.amount - amount;
        }

        private FluidStack drainFrom(FluidStack resource, boolean doDrain, Iterator<IFluidTank> iter) {
            if (resource == null) {
                return null;
            }
            int amount = resource.amount;
            while (iter.hasNext() && amount > 0) {
                FluidStack ret;
                IFluidTank tank = iter.next();
                FluidStack inTank = tank.getFluid();
                if (inTank == null || !inTank.isFluidStackIdentical(resource) || (ret = tank.drain(amount, doDrain)) == null) continue;
                amount -= ret.amount;
            }
            FluidStack ret = resource.copy();
            ret.amount = resource.amount - amount;
            return ret;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.drainFrom(resource, doDrain, this.getApplicableTanks().iterator());
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            Iterator<IFluidTank> iter = this.getApplicableTanks().iterator();
            while (iter.hasNext()) {
                IFluidTank tank = (IFluidTank)iter.next();
                FluidStack stack = tank.drain(maxDrain, doDrain);
                if (stack == null) continue;
                FluidStack drain = stack.copy();
                drain.amount = maxDrain - stack.amount;
                FluidStack additional = this.drainFrom(drain, doDrain, iter);
                if (additional != null) {
                    stack.amount += additional.amount;
                }
                return stack;
            }
            return null;
        }
    }
}

