/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block.te;

import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.element.ComparatorEmitterElement;
import aroma1997.core.inventory.BasicInventory;
import aroma1997.core.inventory.IInventoryPartContainer;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityInventory
extends TileEntityBase
implements ISidedInventory,
IInventoryPartContainer {
    private List<InventoryPartBase> parts = new ArrayList<InventoryPartBase>();
    private IItemHandler[] invCap = new IItemHandler[EnumFacing.field_82609_l.length + 1];
    protected final ComparatorEmitterElement comparator = this.addElement(new ComparatorEmitterElement(this));

    public TileEntityInventory() {
        this.comparator.setRedstoneLookup(this::getFillPercentageComparator);
    }

    @Override
    public void addInventoryPart(InventoryPartBase part) {
        this.parts.add(part);
    }

    @Override
    public int func_70302_i_() {
        return this.parts.stream().mapToInt(BasicInventory::func_70302_i_).sum();
    }

    @Override
    public boolean func_191420_l() {
        return this.parts.stream().allMatch(BasicInventory::func_191420_l);
    }

    public String func_70005_c_() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return ServerUtil.getChatForString(this.func_70005_c_());
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            int id = facing == null ? 0 : facing.ordinal();
            IItemHandler handler = this.invCap[id];
            if (handler == null) {
                handler = this.invCap[id] = new SidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)handler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public Collection<InventoryPartBase> getParts() {
        return this.parts;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (InventoryPartBase part : this.parts) {
            NBTTagCompound current = compound.func_74775_l("inv_" + part.func_70005_c_());
            part.readFromNBT(current);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (InventoryPartBase part : this.parts) {
            NBTTagCompound current = part.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("inv_" + part.func_70005_c_(), (NBTBase)current);
        }
        return compound;
    }

    public int getFillPercentageComparator() {
        int[] availableSlots;
        float ratio = 0.0f;
        for (int slot : availableSlots = this.func_180463_a(null)) {
            ItemStack currentStack = this.func_70301_a(slot);
            ratio += (float)currentStack.func_190916_E() / (float)Math.min(currentStack.func_77976_d(), this.func_70297_j_());
        }
        if (availableSlots.length == 0) {
            return 0;
        }
        return (int)Math.ceil(ratio / (float)availableSlots.length * 15.0f);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        for (InventoryPartBase part : this.getParts()) {
            part.func_174889_b(player);
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        for (InventoryPartBase part : this.getParts()) {
            part.func_174886_c(player);
        }
    }

    @Override
    public void markDirtyInternal() {
        super.func_70296_d();
    }

    @Override
    public final void func_70296_d() {
        for (InventoryPartBase part : this.getParts()) {
            part.markDirtyInternal();
        }
        this.markDirtyInternal();
    }
}

