/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import extracells.item.PowerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;

public abstract class PowerItem$class {
    @Optional.Method(modid="redstoneflux")
    public static int extractEnergy(PowerItem $this, ItemStack container, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            return $this.getEnergyStored(container) >= maxExtract ? maxExtract : $this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, $this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract), Actionable.MODULATE));
    }

    @Optional.Method(modid="redstoneflux")
    public static int getEnergyStored(PowerItem $this, ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, $this.getAECurrentPower(arg0));
    }

    @Optional.Method(modid="redstoneflux")
    public static int getMaxEnergyStored(PowerItem $this, ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, $this.getAEMaxPower(arg0));
    }

    @Optional.Method(modid="redstoneflux")
    public static int receiveEnergy(PowerItem $this, ItemStack container, int maxReceive, boolean simulate) {
        int n;
        if (container == null) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, $this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, $this.getAEMaxPower(container));
            n = max - current >= (double)maxReceive ? maxReceive : (int)(max - current);
        } else {
            double currentAEPower = $this.getAECurrentPower(container);
            n = currentAEPower < $this.getAEMaxPower(container) ? (int)PowerUnits.AE.convertTo(PowerUnits.RF, $this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive), Actionable.MODULATE)) : 0;
        }
        return n;
    }

    public static double injectAEPower(PowerItem $this, ItemStack itemStack, double amt, Actionable actionable) {
        NBTTagCompound tagCompound = PowerItem$class.ensureTagCompound($this, itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toInject = Math.min(amt, $this.MAX_POWER() - currentPower);
        Actionable actionable2 = actionable;
        Actionable actionable3 = Actionable.MODULATE;
        if (!(actionable2 != null ? !actionable2.equals(actionable3) : actionable3 != null)) {
            tagCompound.func_74780_a("power", currentPower + toInject);
        }
        return toInject;
    }

    public static double extractAEPower(PowerItem $this, ItemStack itemStack, double amt, Actionable actionable) {
        NBTTagCompound tagCompound = PowerItem$class.ensureTagCompound($this, itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toExtract = Math.min(amt, currentPower);
        Actionable actionable2 = actionable;
        Actionable actionable3 = Actionable.MODULATE;
        if (!(actionable2 != null ? !actionable2.equals(actionable3) : actionable3 != null)) {
            tagCompound.func_74780_a("power", currentPower - toExtract);
        }
        return toExtract;
    }

    public static double getAECurrentPower(PowerItem $this, ItemStack itemStack) {
        NBTTagCompound tagCompound = PowerItem$class.ensureTagCompound($this, itemStack);
        return tagCompound.func_74769_h("power");
    }

    public static double getAEMaxPower(PowerItem $this, ItemStack itemStack) {
        return $this.MAX_POWER();
    }

    private static NBTTagCompound ensureTagCompound(PowerItem $this, ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public static boolean shouldCauseReequipAnimation(PowerItem $this, ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static void $init$(PowerItem $this) {
    }
}

