/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import extracells.item.ItemECBase;
import extracells.registries.ItemEnum;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidPattern
extends ItemECBase {
    @Nullable
    public static Fluid getFluid(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        if (fluidStack == null) {
            return null;
        }
        return fluidStack.getFluid();
    }

    public static ItemStack getPatternForFluid(Fluid fluid) {
        ItemStack itemStack = new ItemStack(ItemEnum.FLUIDPATTERN.getItem(), 1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return itemStack;
        }
        fluidHandler.fill(new FluidStack(fluid, 1000), true);
        return itemStack;
    }

    public ItemFluidPattern() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStackSimple(stack, 1000);
    }

    public String func_77653_i(ItemStack itemStack) {
        Fluid fluid = ItemFluidPattern.getFluid(itemStack);
        if (fluid == null) {
            return I18n.func_74838_a((String)this.func_77667_c(itemStack));
        }
        return I18n.func_74838_a((String)this.func_77667_c(itemStack)) + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1));
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList itemList) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        super.func_150895_a(creativeTab, itemList);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            itemList.add((Object)ItemFluidPattern.getPatternForFluid(fluid));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.fluid.pattern";
    }

    public ActionResult func_77659_a(World world, EntityPlayer entityPlayer, EnumHand hand) {
        ItemStack itemStack = entityPlayer.func_184586_b(hand);
        if (entityPlayer.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemEnum.FLUIDPATTERN.getSizedStack(itemStack.func_190916_E()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }
}

