/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.mekanism.gas;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IItemList;
import extracells.api.gas.IAEGasStack;
import extracells.integration.mekanism.gas.GasIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GasList
implements IItemList<IAEGasStack> {
    private final Map<IAEGasStack, IAEGasStack> records = new HashMap<IAEGasStack, IAEGasStack>();

    public void addStorage(IAEGasStack iaeGasStack) {
        if (iaeGasStack == null) {
            return;
        }
        IAEGasStack stack = this.getGasRecord(iaeGasStack);
        if (stack != null) {
            stack.add(iaeGasStack);
            return;
        }
        IAEGasStack toAdd = iaeGasStack.copy();
        this.putGasRecord(toAdd);
    }

    public void addCrafting(IAEGasStack iaeGasStack) {
        if (iaeGasStack == null) {
            return;
        }
        IAEGasStack stack = this.getGasRecord(iaeGasStack);
        if (stack != null) {
            stack.setCraftable(true);
            return;
        }
        IAEGasStack toAdd = iaeGasStack.copy();
        toAdd.setStackSize(0L);
        toAdd.setCraftable(true);
        this.putGasRecord(toAdd);
    }

    public void addRequestable(IAEGasStack iaeGasStack) {
        if (iaeGasStack == null) {
            return;
        }
        IAEGasStack stack = this.getGasRecord(iaeGasStack);
        if (stack != null) {
            stack.setCountRequestable(stack.getCountRequestable() + iaeGasStack.getCountRequestable());
            return;
        }
        IAEGasStack toAdd = iaeGasStack.copy();
        toAdd.setStackSize(0L);
        toAdd.setCraftable(false);
        toAdd.setCountRequestable(iaeGasStack.getCountRequestable());
        this.putGasRecord(toAdd);
    }

    public IAEGasStack getFirstItem() {
        Iterator<IAEGasStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEGasStack stack = iterator.next();
            return stack;
        }
        return null;
    }

    public int size() {
        return this.records.values().size();
    }

    public Iterator<IAEGasStack> iterator() {
        return new GasIterator<IAEGasStack>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEGasStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEGasStack gasStack = iterator.next();
            gasStack.reset();
        }
    }

    public void add(IAEGasStack iaeGasStack) {
        if (iaeGasStack == null) {
            return;
        }
        IAEGasStack stack = this.getGasRecord(iaeGasStack);
        if (stack != null) {
            stack.add(iaeGasStack);
        }
        IAEGasStack toAdd = iaeGasStack.copy();
        this.putGasRecord(toAdd);
    }

    public IAEGasStack findPrecise(IAEGasStack iaeGasStack) {
        if (iaeGasStack == null) {
            return null;
        }
        return this.getGasRecord(iaeGasStack);
    }

    public Collection<IAEGasStack> findFuzzy(IAEGasStack iaeGasStack, FuzzyMode fuzzyMode) {
        if (iaeGasStack == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.findPrecise(iaeGasStack));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private IAEGasStack getGasRecord(IAEGasStack gas) {
        return this.records.get(gas);
    }

    private IAEGasStack putGasRecord(IAEGasStack gas) {
        return this.records.put(gas, gas);
    }
}

