/*
 * Decompiled with CFR 0.152.
 */
package omtteam.ompd.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.config.Config;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.render.camo.ICamoSupport;
import omtteam.omlib.blocks.BlockAbstractCamoTileEntity;
import omtteam.omlib.compatibility.theoneprobe.TOPInfoModifier;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.camo.CamoResult;
import omtteam.omlib.util.camo.EnumTool;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.ompd.OpenModularPassiveDefense;
import omtteam.ompd.tileentity.TileEntityCamo;
import omtteam.ompd.util.BlockHelper;

@MethodsReturnNonnullByDefault
public class BlockCamoTrap
extends BlockAbstractCamoTileEntity
implements TOPInfoModifier {
    public static final IProperty<EnumTool> TOOL = PropertyEnum.func_177709_a((String)"tools", EnumTool.class);

    public BlockCamoTrap() {
        super(Material.field_151575_d);
        this.func_149647_a(OpenModularPassiveDefense.modularPassiveDefenseTab);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("axe", 2);
        this.func_149663_c("camo_trap");
        this.setRegistryName("ompd", "camo_trap");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TOOL, (Comparable)EnumTool.SHOVEL));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TOOL}, new IUnlistedProperty[]{RENDERBLOCKSTATE});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCamo(state);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        CamoResult camoResult = this.handleCamoActivation(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        if (camoResult.isSuccess() && camoResult.getTool() != null) {
            world.func_180501_a(pos, state.func_177226_a(TOOL, (Comparable)camoResult.getTool()), 3);
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TOOL, (Comparable)EnumTool.values()[meta]);
    }

    @ParametersAreNonnullByDefault
    public int func_176201_c(IBlockState state) {
        return ((EnumTool)state.func_177229_b(TOOL)).ordinal();
    }

    @ParametersAreNonnullByDefault
    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityOwnedBlock && entityIn instanceof EntityPlayer && PlayerUtil.isPlayerOwner((EntityPlayer)((EntityPlayer)entityIn), (IHasOwner)((TileEntityOwnedBlock)tileEntity))) {
            BlockCamoTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185505_j);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockHelper.onBlockPlacedBy(worldIn, pos, state, placer, stack, (Block)this);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public String getHarvestTool(IBlockState state) {
        EnumTool tool = (EnumTool)state.func_177229_b(TOOL);
        return tool.func_176610_l();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ICamoSupport te = null;
        if (world.func_175625_s(pos) instanceof ICamoSupport) {
            te = (ICamoSupport)world.func_175625_s(pos);
        }
        if (te != null) {
            return new ItemStack(te.getCamoState().func_177230_c(), 1);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        ICamoSupport te = (ICamoSupport)world.func_175625_s(data.getPos());
        if (te != null) {
            BlockPos pos = data.getPos();
            IProbeConfig config = Config.getRealConfig();
            if (!PlayerUtil.isPlayerOwner((EntityPlayer)player, (IHasOwner)te.getOwnedBlock())) {
                DefaultProbeInfoProvider.showStandardBlockInfo((IProbeConfig)config, (ProbeMode)mode, (IProbeInfo)probeInfo, (IBlockState)te.getCamoState(), (Block)te.getCamoState().func_177230_c(), (World)world, (BlockPos)pos, (EntityPlayer)player, (IProbeHitData)data);
            } else {
                DefaultProbeInfoProvider.showStandardBlockInfo((IProbeConfig)config, (ProbeMode)mode, (IProbeInfo)probeInfo, (IBlockState)blockState, (Block)blockState.func_177230_c(), (World)world, (BlockPos)pos, (EntityPlayer)player, (IProbeHitData)data);
            }
        }
    }
}

