/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.potion.potion;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.potion.PotionBase;
import zabi.minecraft.extraalchemy.potion.PotionReference;

public class PotionBeheading
extends PotionBase {
    public PotionBeheading(boolean isBadEffectIn, int liquidColorIn) {
        super(isBadEffectIn, liquidColorIn, "beheading");
        this.func_76399_b(3, 2);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return false;
    }

    public static class PotionBeheadingHandler {
        @SubscribeEvent
        public void onEntityKilled(LivingDropsEvent evt) {
            ItemStack stack;
            if (evt.getEntityLiving().func_130014_f_().field_72995_K) {
                return;
            }
            PotionEffect pe = evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.BEHEADING);
            if (pe != null && this.rollChance(pe.func_76458_c()) && !(stack = this.getHead(evt.getEntityLiving())).func_190926_b()) {
                for (EntityItem ei : evt.getDrops()) {
                    if (!(Block.func_149634_a((Item)ei.func_92059_d().func_77973_b()) instanceof BlockSkull)) continue;
                    return;
                }
                EntityItem eni = new EntityItem(evt.getEntityLiving().func_130014_f_(), evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, stack);
                eni.func_174869_p();
                eni.lifespan = 60;
                evt.getDrops().add(eni);
            }
        }

        private boolean rollChance(int amplifier) {
            double roll = Math.random();
            double chance = amplifier == 0 ? ModConfig.options.beheadingChanceLower : ModConfig.options.beheadingChanceHigher;
            return roll < chance;
        }

        private ItemStack getHead(EntityLivingBase entity) {
            if (entity instanceof EntitySkeleton) {
                return new ItemStack(Items.field_151144_bL, 1, 0);
            }
            if (entity instanceof EntityWitherSkeleton) {
                return new ItemStack(Items.field_151144_bL, 1, 1);
            }
            if (entity instanceof EntityZombie) {
                return new ItemStack(Items.field_151144_bL, 1, 2);
            }
            if (entity instanceof EntityCreeper) {
                return new ItemStack(Items.field_151144_bL, 1, 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.func_74778_a("SkullOwner", entity.func_145748_c_().func_150254_d());
                head.func_77982_d(nametag);
                return head;
            }
            return ItemStack.field_190927_a;
        }
    }
}

