/*
 * Decompiled with CFR 0.152.
 */
package lex.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import lex.IModData;
import lex.block.BlockLibEx;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockVinesLibEx
extends BlockLibEx
implements IShearable {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockVinesLibEx(IModData data, String name, Material material) {
        super(data, name, material);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisAlignedBB = field_185505_j;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            axisAlignedBB = UP_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            axisAlignedBB = NORTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            axisAlignedBB = EAST_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            axisAlignedBB = SOUTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            axisAlignedBB = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisAlignedBB : field_185505_j;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.field_73012_v.nextInt(4) == 0) {
            int j = 5;
            boolean flag = false;
            block0: for (int posX = -4; posX <= 4; ++posX) {
                for (int posZ = -4; posZ <= 4; ++posZ) {
                    for (int posY = -1; posY <= 1; ++posY) {
                        if (world.func_180495_p(pos.func_177982_a(posX, posY, posZ)).func_177230_c() != this || --j > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            EnumFacing facing = EnumFacing.func_176741_a((Random)rand);
            BlockPos upPos = pos.func_177984_a();
            if (facing == EnumFacing.UP && pos.func_177956_o() < 255 && world.func_175623_d(upPos)) {
                IBlockState originalState = state;
                for (EnumFacing horizontalFacing : EnumFacing.Plane.HORIZONTAL) {
                    if (rand.nextBoolean() && this.canAttachTo(world, upPos, horizontalFacing.func_176734_d())) {
                        originalState = originalState.func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(horizontalFacing), (Comparable)Boolean.valueOf(true));
                        continue;
                    }
                    originalState = originalState.func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(horizontalFacing), (Comparable)Boolean.valueOf(false));
                }
                if (((Boolean)originalState.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)WEST)).booleanValue()) {
                    world.func_180501_a(upPos, originalState, 2);
                }
            } else if (facing.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)BlockVinesLibEx.getPropertyFor(facing))).booleanValue()) {
                if (!flag) {
                    BlockPos offsetPos = pos.func_177972_a(facing);
                    IBlockState checkState = world.func_180495_p(offsetPos);
                    if (checkState.func_185904_a() == Material.field_151579_a) {
                        EnumFacing rotatedFacing = facing.func_176746_e();
                        EnumFacing reverseRotatedFacing = facing.func_176735_f();
                        boolean rotated = (Boolean)state.func_177229_b((IProperty)BlockVinesLibEx.getPropertyFor(rotatedFacing));
                        boolean reverseRotated = (Boolean)state.func_177229_b((IProperty)BlockVinesLibEx.getPropertyFor(reverseRotatedFacing));
                        BlockPos rotatedPos = offsetPos.func_177972_a(rotatedFacing);
                        BlockPos reverseRotatedPos = offsetPos.func_177972_a(reverseRotatedFacing);
                        if (rotated && this.canAttachTo(world, rotatedPos.func_177972_a(rotatedFacing), rotatedFacing)) {
                            world.func_180501_a(offsetPos, this.func_176223_P().func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(rotatedFacing), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (reverseRotated && this.canAttachTo(world, reverseRotatedPos.func_177972_a(reverseRotatedFacing), reverseRotatedFacing)) {
                            world.func_180501_a(offsetPos, this.func_176223_P().func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(reverseRotatedFacing), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (rotated && world.func_175623_d(rotatedPos) && this.canAttachTo(world, rotatedPos, facing)) {
                            world.func_180501_a(rotatedPos, this.func_176223_P().func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (reverseRotated && world.func_175623_d(reverseRotatedPos) && this.canAttachTo(world, reverseRotatedPos, facing)) {
                            world.func_180501_a(reverseRotatedPos, this.func_176223_P().func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                        }
                    } else if (checkState.func_193401_d((IBlockAccess)world, offsetPos, facing) == BlockFaceShape.SOLID) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(facing), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else if (pos.func_177956_o() > 1) {
                BlockPos downPos = pos.func_177977_b();
                IBlockState checkState = world.func_180495_p(downPos);
                Block checkBlock = checkState.func_177230_c();
                if (checkState.func_185904_a() == Material.field_151579_a) {
                    IBlockState originalState = state;
                    for (EnumFacing horizontalFacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean()) continue;
                        originalState = originalState.func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(horizontalFacing), (Comparable)Boolean.valueOf(false));
                    }
                    if (((Boolean)originalState.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)originalState.func_177229_b((IProperty)WEST)).booleanValue()) {
                        world.func_180501_a(downPos, originalState, 2);
                    }
                } else if (checkBlock == this) {
                    IBlockState originalCheckState = checkState;
                    for (EnumFacing horizontalFacing : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool bool = BlockVinesLibEx.getPropertyFor(horizontalFacing);
                        if (!rand.nextBoolean() || !((Boolean)state.func_177229_b((IProperty)bool)).booleanValue()) continue;
                        originalCheckState = originalCheckState.func_177226_a((IProperty)bool, (Comparable)Boolean.valueOf(true));
                    }
                    if (((Boolean)originalCheckState.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)originalCheckState.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)originalCheckState.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)originalCheckState.func_177229_b((IProperty)WEST)).booleanValue()) {
                        world.func_180501_a(downPos, originalCheckState, 2);
                    }
                }
            }
        }
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && this.canAttachTo(world, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K && !this.recheckGrownSides(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false));
        return facing.func_176740_k().func_176722_c() ? state.func_177226_a((IProperty)BlockVinesLibEx.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)) : state;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this, 1));
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileEntity, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            BlockVinesLibEx.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, 0));
        } else {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(world.func_180495_p(blockpos).func_193401_d(world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            meta |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public boolean canAttachTo(World world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.isAcceptableNeighbor(world, pos.func_177972_a(facing.func_176734_d()), facing) && (block == Blocks.field_150350_a || block == Blocks.field_150395_bd || this.isAcceptableNeighbor(world, pos.func_177984_a(), EnumFacing.UP));
    }

    private boolean isAcceptableNeighbor(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)world, pos, facing) == BlockFaceShape.SOLID && !BlockVinesLibEx.isExceptBlockForAttaching(state.func_177230_c());
    }

    protected static boolean isExceptBlockForAttaching(Block block) {
        return block instanceof BlockShulkerBox || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K || block == Blocks.field_150415_aT;
    }

    private boolean recheckGrownSides(World world, BlockPos pos, IBlockState state) {
        IBlockState originalState = state;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState checkState;
            PropertyBool bool = BlockVinesLibEx.getPropertyFor(facing);
            if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue() || this.canAttachTo(world, pos, facing.func_176734_d()) || (checkState = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this && ((Boolean)checkState.func_177229_b((IProperty)bool)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)bool, (Comparable)Boolean.valueOf(false));
        }
        if (BlockVinesLibEx.getNumGrownFaces(state) == 0) {
            return false;
        }
        if (originalState != state) {
            world.func_180501_a(pos, state, 2);
        }
        return true;
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    public static int getNumGrownFaces(IBlockState state) {
        int grownSides = 0;
        for (PropertyBool bool : ALL_FACES) {
            if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue()) continue;
            ++grownSides;
        }
        return grownSides;
    }
}

