/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.chemistry;

import al132.alchemistry.chemistry.ChemicalElement;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lal132/alchemistry/chemistry/ElementRegistry;", "", "()V", "elements", "Ljava/util/HashMap;", "", "Lal132/alchemistry/chemistry/ChemicalElement;", "add", "", "atomicNumber", "name", "", "abbreviation", "color", "Ljava/awt/Color;", "get", "elementName", "getAllElements", "", "getMeta", "init", "", "keys", "alchemistry"})
public final class ElementRegistry {
    private static final HashMap<Integer, ChemicalElement> elements;
    public static final ElementRegistry INSTANCE;

    public final void init() {
        Color color = Color.blue;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.blue");
        this.add(1, "hydrogen", "H", color);
        Color color2 = Color.red;
        Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.red");
        this.add(2, "helium", "He", color2);
        this.add(3, "lithium", "Li", new Color(40, 158, 86));
        this.add(4, "beryllium", "Be", new Color(184, 199, 224));
        this.add(5, "boron", "B", new Color(154, 176, 226));
        this.add(6, "carbon", "C", new Color(59, 60, 63));
        this.add(7, "nitrogen", "N", new Color(66, 123, 214));
        this.add(8, "oxygen", "O", new Color(229, 220, 156));
        this.add(9, "fluorine", "F", new Color(204, 186, 55));
        this.add(10, "neon", "Ne", new Color(87, 229, 16));
        this.add(11, "sodium", "Na", new Color(211, 198, 131));
        this.add(12, "magnesium", "Mg", new Color(237, 178, 173));
        this.add(13, "aluminum", "Al", new Color(247, 110, 69));
        this.add(14, "silicon", "Si", new Color(173, 178, 121));
        this.add(15, "phosphorus", "P", new Color(234, 98, 132));
        this.add(16, "sulfur", "S", new Color(145, 158, 6));
        this.add(17, "chlorine", "Cl", new Color(77, 102, 28));
        this.add(18, "argon", "Ar", new Color(119, 117, 255));
        this.add(19, "potassium", "K", new Color(198, 152, 95));
        this.add(20, "calcium", "Ca", new Color(219, 210, 199));
        this.add(21, "scandium", "Sc", new Color(252, 255, 99));
        this.add(22, "titanium", "Ti", new Color(99, 255, 115));
        this.add(23, "vanadium", "V", new Color(195, 186, 242));
        this.add(24, "chromium", "Cr", new Color(236, 237, 218));
        this.add(25, "manganese", "Mn", new Color(225, 186, 242));
        Color color3 = Color.gray;
        Intrinsics.checkExpressionValueIsNotNull((Object)color3, (String)"Color.gray");
        this.add(26, "iron", "Fe", color3);
        this.add(27, "cobalt", "Co", new Color(17, 114, 198));
        this.add(28, "nickel", "Ni", new Color(198, 157, 162));
        this.add(29, "copper", "Cu", new Color(255, 154, 30));
        this.add(30, "zinc", "Zn", new Color(189, 196, 141));
        this.add(31, "gallium", "Ga", new Color(122, 20, 49));
        this.add(32, "germanium", "Ge", new Color(104, 172, 255));
        this.add(33, "arsenic", "As", new Color(62, 145, 76));
        this.add(34, "selenium", "Se", new Color(116, 62, 145));
        this.add(35, "bromine", "Br", new Color(77, 160, 0));
        this.add(36, "krypton", "Kr", new Color(229, 151, 50));
        this.add(37, "rubidium", "Rb", new Color(15, 61, 40));
        this.add(38, "strontium", "Sr", new Color(206, 88, 24));
        this.add(39, "yttrium", "Y", new Color(206, 179, 24));
        this.add(40, "zirconium", "Zr", new Color(127, 80, 22));
        this.add(41, "niobium", "Nb", new Color(2, 29, 255));
        this.add(42, "molybdenum", "Mo", new Color(39, 0, 48));
        this.add(43, "technetium", "Tc", new Color(72, 170, 63));
        this.add(44, "ruthenium", "Ru", new Color(255, 240, 86));
        this.add(45, "rhodium", "Rh", new Color(255, 0, 80));
        this.add(46, "palladium", "Pd", new Color(0, 255, 169));
        this.add(47, "silver", "Ag", new Color(226, 217, 206));
        this.add(48, "cadmium", "Cd", new Color(160, 147, 115));
        this.add(49, "indium", "In", new Color(163, 230, 255));
        this.add(50, "tin", "Sn", new Color(132, 161, 206));
        this.add(51, "antimony", "Sb", new Color(193, 40, 58));
        this.add(52, "tellurium", "Te", new Color(39, 91, 26));
        this.add(53, "iodine", "I", new Color(62, 17, 63));
        this.add(54, "xenon", "Xe", new Color(196, 51, 204));
        this.add(55, "cesium", "Cs", new Color(255, 148, 0));
        this.add(56, "barium", "Ba", new Color(0, 219, 179));
        this.add(57, "lanthanum", "La", new Color(188, 253, 255));
        this.add(58, "cerium", "Ce", new Color(255, 254, 211));
        this.add(59, "praseodymium", "Pr", new Color(255, 161, 0));
        this.add(60, "neodymium", "Nd", new Color(38, 28, 11));
        this.add(61, "promethium", "Pm", new Color(105, 175, 123));
        this.add(62, "samarium", "Sm", new Color(73, 69, 73));
        this.add(63, "europium", "Eu", new Color(27, 211, 45));
        this.add(64, "gadolinium", "Gd", new Color(123, 50, 208));
        this.add(65, "terbium", "Tb", new Color(3, 37, 118));
        this.add(66, "dysprosium", "Dy", new Color(73, 0, 219));
        this.add(67, "holmium", "Ho", new Color(62, 255, 56));
        this.add(68, "erbium", "Er", new Color(194, 214, 215));
        this.add(69, "thulium", "Tm", new Color(234, 178, 178));
        this.add(70, "ytterbium", "Yb", new Color(255, 76, 219));
        this.add(71, "lutetium", "Lu", new Color(175, 0, 219));
        this.add(72, "hafnium", "Hf", new Color(69, 81, 233));
        this.add(73, "tantalum", "Ta", new Color(108, 142, 110));
        this.add(74, "tungsten", "W", new Color(120, 128, 140));
        this.add(75, "rhenium", "Re", new Color(199, 226, 89));
        this.add(76, "osmium", "Os", new Color(102, 129, 173));
        this.add(77, "iridium", "Ir", new Color(215, 242, 238));
        this.add(78, "platinum", "Pt", new Color(114, 202, 229));
        Color color4 = Color.yellow;
        Intrinsics.checkExpressionValueIsNotNull((Object)color4, (String)"Color.yellow");
        this.add(79, "gold", "Au", color4);
        this.add(80, "mercury", "Hg", new Color(160, 159, 157));
        this.add(81, "thallium", "Tl", new Color(103, 50, 25));
        this.add(82, "lead", "Pb", new Color(186, 135, 193));
        this.add(83, "bismuth", "Bi", new Color(252, 171, 40));
        this.add(84, "polonium", "Po", new Color(138, 87, 85));
        this.add(85, "astatine", "At", new Color(120, 128, 213));
        this.add(86, "radon", "Rn", new Color(76, 66, 179));
        this.add(87, "francium", "Fr", new Color(81, 114, 198));
        this.add(88, "radium", "Ra", new Color(255, 181, 221));
        this.add(89, "actinium", "Ac", new Color(14, 182, 145));
        this.add(90, "thorium", "Th", new Color(56, 79, 75));
        this.add(91, "protactinium", "Pa", new Color(204, 233, 2));
        this.add(92, "uranium", "U", new Color(93, 178, 19));
        this.add(93, "neptunium", "Np", new Color(32, 20, 158));
        this.add(94, "plutonium", "Pu", new Color(211, 211, 209));
        this.add(95, "americium", "Am", new Color(237, 124, 75));
        this.add(96, "curium", "Cm", new Color(229, 110, 149));
        this.add(97, "berkelium", "Bk", new Color(44, 66, 49));
        this.add(98, "californium", "Cf", new Color(175, 182, 16));
        this.add(99, "einsteinium", "Es", new Color(192, 210, 95));
        this.add(100, "fermium", "Fm", new Color(74, 226, 83));
        this.add(101, "mendelevium", "Md", new Color(175, 176, 249));
        this.add(102, "nobelium", "No", new Color(94, 44, 52));
        this.add(103, "lawrencium", "Lr", new Color(216, 45, 92));
        this.add(104, "rutherfordium", "Rf", new Color(240, 61, 22));
        this.add(105, "dubnium", "Db", new Color(11, 112, 108));
        this.add(106, "seaborgium", "Sg", new Color(158, 49, 74));
        this.add(107, "bohrium", "Bh", new Color(166, 251, 51));
        this.add(108, "hassium", "Hs", new Color(78, 5, 51));
        this.add(109, "meitnerium", "Mt", new Color(169, 138, 37));
        this.add(110, "darmstadtium", "Ds", new Color(14, 144, 190));
        this.add(111, "roentgenium", "Rg", new Color(150, 90, 90));
        this.add(112, "copernicium", "Cn", new Color(160, 40, 240));
        this.add(113, "nihonium", "Nh", new Color(220, 250, 180));
        this.add(114, "flerovium", "Fl", new Color(200, 180, 254));
        this.add(115, "moscovium", "Mc", new Color(250, 180, 200));
        this.add(116, "livermorium", "Lv", new Color(250, 250, 200));
        this.add(117, "tennessine", "Ts", new Color(150, 250, 250));
        this.add(118, "oganesson", "Og", new Color(250, 150, 250));
    }

    @Nullable
    public final ChemicalElement get(int atomicNumber) {
        Object v1;
        block1: {
            Collection<ChemicalElement> collection = elements.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"elements.values");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                ChemicalElement it = (ChemicalElement)element$iv;
                if (!(it.getMeta() == atomicNumber)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final ChemicalElement get(@NotNull String elementName) {
        Object v1;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
            Collection<ChemicalElement> collection = elements.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"elements.values");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                ChemicalElement it = (ChemicalElement)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)elementName)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean add(int atomicNumber, @NotNull String name, @NotNull String abbreviation, @NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)abbreviation, (String)"abbreviation");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        if (elements.containsKey(atomicNumber)) {
            return false;
        }
        Map map = elements;
        Integer n = atomicNumber;
        ChemicalElement chemicalElement = new ChemicalElement(name, abbreviation, color);
        map.put(n, chemicalElement);
        return true;
    }

    public static /* synthetic */ boolean add$default(ElementRegistry elementRegistry, int n, String string, String string2, Color color, int n2, Object object) {
        if ((n2 & 8) != 0) {
            Color color2 = Color.white;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.white");
            color = color2;
        }
        return elementRegistry.add(n, string, string2, color);
    }

    public final int getMeta(@NotNull String name) {
        Object object;
        Object v1;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Set<Map.Entry<Integer, ChemicalElement>> set = elements.entrySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"elements.entries");
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual((Object)((ChemicalElement)it.getValue()).getName(), (Object)name)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return (object = (Map.Entry)v1) != null && (object = (Integer)object.getKey()) != null ? (Integer)object : -1;
    }

    @NotNull
    public final Set<ChemicalElement> getAllElements() {
        Collection<ChemicalElement> collection = elements.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"this.elements.values");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @NotNull
    public final Set<Integer> keys() {
        Set<Integer> set = elements.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"this.elements.keys");
        return CollectionsKt.toSet((Iterable)set);
    }

    private ElementRegistry() {
    }

    static {
        ElementRegistry elementRegistry;
        INSTANCE = elementRegistry = new ElementRegistry();
        elements = new HashMap();
    }
}

