/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;

public class ItemMetaRegistry<E> {
    private Map<Item, Map<Integer, E>> registry = new HashMap<Item, Map<Integer, E>>();
    private boolean compactTopLevel;

    public ItemMetaRegistry() {
    }

    public ItemMetaRegistry(boolean compactTopLevel) {
        this();
        this.compactTopLevel = compactTopLevel;
    }

    public void register(Item item, int meta, E entry) {
        Map<Integer, E> metamap = this.registry.get(item);
        if (metamap == null) {
            metamap = new HashMap<Integer, E>();
            this.registry.put(item, metamap);
        }
        metamap.put(meta, entry);
    }

    public E getEntry(Item item, int meta) {
        Map<Integer, E> metamap = this.registry.get(item);
        if (metamap == null) {
            return null;
        }
        return metamap.get(meta);
    }

    public void remove(Item item, int meta) {
        Map<Integer, E> metamap = this.registry.get(item);
        if (metamap == null) {
            return;
        }
        metamap.remove(meta);
        if (this.compactTopLevel && metamap.isEmpty()) {
            this.registry.remove(item);
        }
    }

    public void clear(Item item) {
        Map<Integer, E> metamap = this.registry.get(item);
        if (metamap == null) {
            return;
        }
        metamap.clear();
        if (this.compactTopLevel) {
            this.registry.remove(item);
        }
    }

    public void clear() {
        if (this.compactTopLevel) {
            this.registry.clear();
        } else {
            for (Item item : this.registry.keySet()) {
                this.clear(item);
            }
        }
    }

    public Set<Map.Entry<Item, Map<Integer, E>>> entrySet() {
        return this.registry.entrySet();
    }

    public Set<Map.Entry<Integer, E>> entrySet(Item item) {
        Map<Integer, E> metamap = this.registry.get(item);
        if (metamap == null) {
            metamap = new HashMap<Integer, E>();
            this.registry.put(item, metamap);
        }
        return metamap.entrySet();
    }
}

