/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityDrawerAttributes {
    @CapabilityInject(value=IDrawerAttributes.class)
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDrawerAttributes.class, (Capability.IStorage)new DefaultStorage(), BasicDrawerAttributes::new);
    }

    private static class DefaultStorage
    implements Capability.IStorage<IDrawerAttributes> {
        private DefaultStorage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IDrawerAttributes> capability, IDrawerAttributes instance, EnumFacing side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("lockedPop", instance.isItemLocked(LockAttribute.LOCK_POPULATED));
            tag.func_74757_a("lockedEmpty", instance.isItemLocked(LockAttribute.LOCK_EMPTY));
            tag.func_74757_a("concealed", instance.isConcealed());
            tag.func_74757_a("void", instance.isVoid());
            tag.func_74757_a("quant", instance.isShowingQuantity());
            tag.func_74757_a("unlimited", instance.isUnlimitedStorage());
            tag.func_74757_a("vending", instance.isUnlimitedVending());
            return tag;
        }

        public void readNBT(Capability<IDrawerAttributes> capability, IDrawerAttributes instance, EnumFacing side, NBTBase nbt) {
            if (instance instanceof INBTSerializable) {
                INBTSerializable serializer = (INBTSerializable)instance;
                serializer.deserializeNBT(nbt);
                return;
            }
            if (!(instance instanceof IDrawerAttributesModifiable)) {
                throw new RuntimeException("IDrawerAttributes instance does not implement IDrawerAttributesModifiable");
            }
            IDrawerAttributesModifiable modifiable = (IDrawerAttributesModifiable)instance;
            NBTTagCompound tag = (NBTTagCompound)nbt;
            modifiable.setItemLocked(LockAttribute.LOCK_POPULATED, tag.func_74767_n("lockedPop"));
            modifiable.setItemLocked(LockAttribute.LOCK_EMPTY, tag.func_74767_n("lockedEmpty"));
            modifiable.setIsConcealed(tag.func_74767_n("concealed"));
            modifiable.setIsVoid(tag.func_74767_n("void"));
            modifiable.setIsShowingQuantity(tag.func_74767_n("quant"));
            modifiable.setIsUnlimitedStorage(tag.func_74767_n("unlimited"));
            modifiable.setIsUnlimitedVending(tag.func_74767_n("vending"));
        }
    }
}

