/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackOreMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;

public abstract class StandardDrawerGroup
extends TileDataShim
implements IDrawerGroup {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private DrawerData[] slots;
    private int[] order;
    private final IItemHandler itemHandler = new DrawerItemHandler(this);
    private final IItemRepository itemRepository = new DrawerItemRepository(this);

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    public void setCapabilityProvider(ICapabilityProvider capProvider) {
        for (DrawerData slot : this.slots) {
            slot.setCapabilityProvider(capProvider);
        }
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @Nonnull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("Drawers")) {
            if (tag.func_74764_b("Slots")) {
                this.readFromLegacyNBT(tag);
            }
            return;
        }
        NBTTagList itemList = tag.func_150295_c("Drawers", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            if (i < 0 || i >= this.slots.length) continue;
            this.slots[i].deserializeNBT(itemList.func_150305_b(i));
        }
    }

    public void readFromLegacyNBT(NBTTagCompound tag) {
        int i;
        NBTTagList slotTags = tag.func_150295_c("Slots", 10);
        DrawerData[] realSlots = new DrawerData[slotTags.func_74745_c()];
        for (i = 0; i < realSlots.length && i < this.slots.length; ++i) {
            realSlots[i] = this.slots[i];
        }
        this.slots = realSlots;
        for (i = 0; i < this.slots.length; ++i) {
            this.slots[i].deserializeLegacyNBT(slotTags.func_150305_b(i));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.slots == null) {
            return tag;
        }
        NBTTagList itemList = new NBTTagList();
        for (DrawerData slot : this.slots) {
            itemList.func_74742_a((NBTBase)slot.serializeNBT());
        }
        tag.func_74782_a("Drawers", (NBTBase)itemList);
        return tag;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ITEM_HANDLER_CAPABILITY || capability == ITEM_REPOSITORY_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return (T)this.itemRepository;
        }
        return null;
    }

    @Nonnull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    public static class DrawerData
    implements IDrawer,
    INBTSerializable<NBTTagCompound> {
        @CapabilityInject(value=IDrawerAttributes.class)
        static Capability<IDrawerAttributes> ATTR_CAPABILITY = null;
        IDrawerAttributes attrs;
        StandardDrawerGroup group;
        @Nonnull
        private ItemStack protoStack;
        private ItemStack publicStack;
        private int count;
        private ItemStackMatcher matcher;
        private Map<String, Object> auxData;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.attrs = new EmptyDrawerAttributes();
            this.protoStack = ItemStack.field_190927_a;
            this.publicStack = ItemStack.field_190927_a;
            this.matcher = ItemStackMatcher.EMPTY;
        }

        public void setCapabilityProvider(ICapabilityProvider capProvider) {
            IDrawerAttributes capAttrs = (IDrawerAttributes)capProvider.getCapability(ATTR_CAPABILITY, null);
            if (capAttrs != null) {
                this.attrs = capAttrs;
            }
        }

        @Override
        @Nonnull
        public ItemStack getStoredItemPrototype() {
            return this.protoStack;
        }

        @Override
        @Nonnull
        public ItemStack getPublicItemStack() {
            this.publicStack.func_190920_e(this.getStoredItemCount());
            return this.publicStack;
        }

        @Override
        @Nonnull
        public IDrawer setStoredItem(@Nonnull ItemStack itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@Nonnull ItemStack itemPrototype, boolean notify) {
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).func_190926_b()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.func_190920_e(1);
            this.publicStack = itemPrototype.func_77946_l();
            this.count = 0;
            this.matcher = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@Nonnull ItemStack itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.func_190920_e(1);
            this.publicStack = itemPrototype.func_77946_l();
            this.count = 0;
            this.matcher = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.func_190926_b() || this.count == amount) {
                return;
            }
            if (this.attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !this.attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.func_190926_b() || amount == 0) {
                return Math.abs(amount);
            }
            if (amount > 0) {
                if (this.attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (this.attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (this.attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@Nonnull ItemStack itemPrototype) {
            if (this.attrs.isUnlimitedStorage() || this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.func_190926_b()) {
                return 64 * this.getStackCapacity();
            }
            return itemPrototype.func_77973_b().getItemStackLimit(itemPrototype) * this.getStackCapacity();
        }

        @Override
        public int getAcceptingMaxCapacity(@Nonnull ItemStack itemPrototype) {
            if (this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.protoStack.func_190926_b()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending() || this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.func_190926_b() && !this.attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.func_190926_b()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.protoStack.func_190926_b();
        }

        protected void reset(boolean notify) {
            this.protoStack = ItemStack.field_190927_a;
            this.publicStack = ItemStack.field_190927_a;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.protoStack.func_190926_b()) {
                return tag;
            }
            NBTTagCompound item = new NBTTagCompound();
            this.protoStack.func_77955_b(item);
            tag.func_74782_a("Item", (NBTBase)item);
            tag.func_74768_a("Count", this.count);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            ItemStack tagItem = ItemStack.field_190927_a;
            int tagCount = 0;
            if (nbt.func_74764_b("Item")) {
                tagItem = new ItemStack(nbt.func_74775_l("Item"));
            }
            if (nbt.func_74764_b("Count")) {
                tagCount = nbt.func_74762_e("Count");
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
            this.onItemChanged();
        }

        public void deserializeLegacyNBT(NBTTagCompound nbt) {
            Item item;
            ItemStack tagItem = ItemStack.field_190927_a;
            int tagCount = 0;
            if (nbt.func_74764_b("Count")) {
                tagCount = nbt.func_74762_e("Count");
            }
            if (nbt.func_74764_b("Item") && (item = Item.func_150899_d((int)nbt.func_74765_d("Item"))) != null) {
                tagItem = new ItemStack(item);
                tagItem.func_77964_b((int)nbt.func_74765_d("Meta"));
                if (nbt.func_74764_b("Tags")) {
                    tagItem.func_77982_d(nbt.func_74775_l("Tags"));
                }
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
            this.onItemChanged();
        }

        public void syncAttributes() {
            if (!this.protoStack.func_190926_b()) {
                this.matcher = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            }
        }

        @Override
        public Object getExtendedData(String key) {
            if (this.auxData == null || !this.auxData.containsKey(key)) {
                return null;
            }
            return this.auxData.get(key);
        }

        @Override
        public void setExtendedData(String key, Object data) {
            if (this.auxData == null) {
                this.auxData = new HashMap<String, Object>();
            }
            this.auxData.put(key, data);
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }
    }
}

