/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class ChargeUtils {
    public static boolean isIC2Chargeable(ItemStack itemStack) {
        return ElectricItem.manager.charge(itemStack, 2.147483647E9, 4, true, true) > 0.0;
    }

    public static boolean isIC2Dischargeable(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, 2.147483647E9, 4, true, true, true) > 0.0;
    }

    public static void discharge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ItemStack stack = inv.func_70301_a(slotID);
        if (!stack.func_190926_b() && storer.getEnergy() < storer.getMaxEnergy()) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(stack, storer.getMaxEnergy() - storer.getEnergy()));
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canExtract()) {
                    int needed = MekanismUtils.clampToInt((storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.current().general.TO_FORGE.val());
                    storer.setEnergy(storer.getEnergy() + (double)storage.extractEnergy(needed, false) * MekanismConfig.current().general.FROM_FORGE.val());
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int needed = MekanismUtils.clampToInt((storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.current().general.TO_RF.val());
                storer.setEnergy(storer.getEnergy() + (double)item.extractEnergy(stack, needed, false) * MekanismConfig.current().general.FROM_RF.val());
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)stack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                long needed = Math.round((storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.current().general.TO_TESLA.val());
                storer.setEnergy(storer.getEnergy() + (double)producer.takePower(needed, false) * MekanismConfig.current().general.FROM_TESLA.val());
            } else if (MekanismUtils.useIC2() && ChargeUtils.isIC2Dischargeable(stack)) {
                double gain = ElectricItem.manager.discharge(stack, (storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.current().general.TO_IC2.val(), 4, true, true, false) * MekanismConfig.current().general.FROM_IC2.val();
                storer.setEnergy(storer.getEnergy() + gain);
            } else if (stack.func_77973_b() == Items.field_151137_ax && storer.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val() <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val());
                stack.func_190918_g(1);
            }
        }
    }

    public static void charge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ChargeUtils.charge(inv.func_70301_a(slotID), storer);
    }

    public static void charge(ItemStack stack, IStrictEnergyStorage storer) {
        if (!stack.func_190926_b() && storer.getEnergy() > 0.0) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(stack, storer.getEnergy()));
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canReceive()) {
                    int stored = MekanismUtils.clampToInt(storer.getEnergy() * MekanismConfig.current().general.TO_FORGE.val());
                    storer.setEnergy(storer.getEnergy() - (double)storage.receiveEnergy(stored, false) * MekanismConfig.current().general.FROM_FORGE.val());
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int toTransfer = MekanismUtils.clampToInt(storer.getEnergy() * MekanismConfig.current().general.TO_RF.val());
                storer.setEnergy(storer.getEnergy() - (double)item.receiveEnergy(stack, toTransfer, false) * MekanismConfig.current().general.FROM_RF.val());
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                long stored = Math.round(storer.getEnergy() * MekanismConfig.current().general.TO_TESLA.val());
                storer.setEnergy(storer.getEnergy() - (double)consumer.givePower(stored, false) * MekanismConfig.current().general.FROM_TESLA.val());
            } else if (MekanismUtils.useIC2() && ChargeUtils.isIC2Chargeable(stack)) {
                double sent = ElectricItem.manager.charge(stack, storer.getEnergy() * MekanismConfig.current().general.TO_IC2.val(), 4, true, false) * MekanismConfig.current().general.FROM_IC2.val();
                storer.setEnergy(storer.getEnergy() - sent);
            }
        }
    }

    public static boolean canBeDischarged(ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canSend(itemstack) && ((IEnergizedItem)itemstack.func_77973_b()).getEnergy(itemstack) > 0.0) {
            return true;
        }
        if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).extractEnergy(itemstack, 1, true) != 0) {
            return true;
        }
        if (MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null) && ((ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)).takePower(1L, true) > 0L) {
            return true;
        }
        if (MekanismUtils.useIC2() && ElectricItem.manager.discharge(itemstack, 1.0, 0, true, true, true) > 0.0) {
            return true;
        }
        return itemstack.func_77973_b() == Items.field_151137_ax;
    }

    public static boolean canBeCharged(ItemStack itemstack) {
        IEnergizedItem energizedItem;
        if (itemstack.func_77973_b() instanceof IEnergizedItem && (energizedItem = (IEnergizedItem)itemstack.func_77973_b()).canReceive(itemstack) && energizedItem.getMaxEnergy(itemstack) < energizedItem.getEnergy(itemstack)) {
            return true;
        }
        if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, 1, true) > 0) {
            return true;
        }
        if (MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null) && ((ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)).givePower(1L, true) > 0L) {
            return true;
        }
        return MekanismUtils.useIC2() && ChargeUtils.isIC2Chargeable(itemstack);
    }

    public static boolean canBeOutputted(ItemStack itemstack, boolean chargeSlot) {
        if (itemstack.func_77973_b() instanceof IEnergizedItem) {
            IEnergizedItem energized = (IEnergizedItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energized.getEnergy(itemstack) == energized.getMaxEnergy(itemstack);
            }
            return energized.getEnergy(itemstack) == 0.0;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energyContainer.receiveEnergy(itemstack, 1, true) == 0;
            }
            return energyContainer.extractEnergy(itemstack, 1, true) == 0;
        }
        if (MekanismUtils.useTesla()) {
            if (chargeSlot && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                return consumer.givePower(1L, true) == 0L;
            }
            if (!chargeSlot && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                return producer.takePower(1L, true) == 0L;
            }
        } else {
            IElectricItemManager manager;
            if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
                if (chargeSlot) {
                    return !storage.canReceive() || storage.receiveEnergy(1, true) == 0;
                }
                return !storage.canExtract() || storage.extractEnergy(1, true) == 0;
            }
            if (MekanismUtils.useIC2() && (ChargeUtils.isIC2Chargeable(itemstack) || ChargeUtils.isIC2Dischargeable(itemstack)) && (manager = ElectricItem.manager) != null) {
                if (chargeSlot) {
                    return manager.charge(itemstack, 1.0, 3, true, true) == 0.0;
                }
                return manager.discharge(itemstack, 1.0, 3, true, true, true) == 0.0;
            }
        }
        return true;
    }
}

