/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransporterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TextComponentGroup;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLogisticalTransporter
extends TileEntityTransmitter<TileEntity, InventoryNetwork, Void> {
    private final int SYNC_PACKET = 1;
    private final int BATCH_PACKET = 2;
    public TransporterTier tier = TransporterTier.BASIC;
    private int delay = 0;
    private int delayCount = 0;

    public TileEntityLogisticalTransporter() {
        this.transmitterDelegate = new TransporterImpl(this);
    }

    @Override
    public BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(BaseTier baseTier) {
        this.tier = TransporterTier.get(baseTier);
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.LOGISTICAL_TRANSPORTER;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    @Override
    public void onWorldSeparate() {
        super.onWorldSeparate();
        if (!this.func_145831_w().field_72995_K) {
            PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
        }
    }

    @Override
    public TileEntity getCachedAcceptor(EnumFacing side) {
        return this.getCachedTile(side);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tileEntity) {
        ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
        if (this.getTransmitter().getColor() == null || transporter.getColor() == null || this.getTransmitter().getColor() == transporter.getColor()) {
            return super.isValidTransmitter(tileEntity);
        }
        return false;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        return TransporterUtils.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.getTransmitter().update();
    }

    public void pullItems() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = 3;
        for (EnumFacing side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
            TransitRequest request;
            TileEntity tile = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side));
            if (tile == null || (request = TransitRequest.buildInventoryMap(tile, side, this.tier.getPullAmount())).isEmpty()) continue;
            TransitRequest.TransitResponse response = TransporterUtils.insert(tile, this.getTransmitter(), request, this.getTransmitter().getColor(), true, 0);
            if (!response.isEmpty()) {
                response.getInvStack(tile, side.func_176734_d()).use(response.getSendingAmount());
                this.delay = 10;
                continue;
            }
            ++this.delayCount;
            this.delay = Math.min(40, (int)Math.exp(this.delayCount));
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
    }

    @Override
    public InventoryNetwork createNewNetwork() {
        return new InventoryNetwork();
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            int type = dataStream.readInt();
            if (type == 0) {
                super.handlePacketData(dataStream);
                this.tier = TransporterTier.values()[dataStream.readInt()];
                int c = dataStream.readInt();
                EnumColor prev = this.getTransmitter().getColor();
                if (c != -1) {
                    this.getTransmitter().setColor(TransporterUtils.colors.get(c));
                } else {
                    this.getTransmitter().setColor(null);
                }
                if (prev != this.getTransmitter().getColor()) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_174879_c);
                }
                this.getTransmitter().readFromPacket(dataStream);
            } else if (type == 1) {
                this.readStack(dataStream);
            } else if (type == 2) {
                int updates = dataStream.readInt();
                for (int i = 0; i < updates; ++i) {
                    this.readStack(dataStream);
                }
                int deletes = dataStream.readInt();
                for (int i = 0; i < deletes; ++i) {
                    this.getTransmitter().deleteStack(dataStream.readInt());
                }
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(0);
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        } else {
            data.add(-1);
        }
        this.getTransmitter().writeToPacket(data);
        return data;
    }

    public TileNetworkList makeSyncPacket(int stackId, TransporterStack stack) {
        TileNetworkList data = new TileNetworkList();
        if (Mekanism.hooks.MCMPLoaded) {
            MultipartTileNetworkJoiner.addMultipartHeader(this, data, null);
        }
        data.add(1);
        data.add(stackId);
        stack.write(this.getTransmitter(), data);
        return data;
    }

    public TileNetworkList makeBatchPacket(Map<Integer, TransporterStack> updates, Set<Integer> deletes) {
        TileNetworkList data = new TileNetworkList();
        if (Mekanism.hooks.MCMPLoaded) {
            MultipartTileNetworkJoiner.addMultipartHeader(this, data, null);
        }
        data.add(2);
        data.add(updates.size());
        for (Map.Entry<Integer, TransporterStack> entry : updates.entrySet()) {
            data.add(entry.getKey());
            entry.getValue().write(this.getTransmitter(), data);
        }
        data.add(deletes.size());
        data.addAll(deletes);
        return data;
    }

    private void readStack(ByteBuf dataStream) {
        int id = dataStream.readInt();
        TransporterStack stack = TransporterStack.readFromPacket(dataStream);
        if (stack.progress == 0) {
            stack.progress = 5;
        }
        this.getTransmitter().addStack(id, stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = TransporterTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.getTransmitter().readFromNBT(nbtTags);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.getTransmitter().getTransit()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
        return nbtTags;
    }

    @Override
    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        TransporterUtils.incrementColor(this.getTransmitter());
        this.onPartChanged(null);
        PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
        Mekanism.packetHandler.sendUpdatePacket(this);
        TextComponentGroup msg = new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism] ", TextFormatting.DARK_BLUE).translation("tooltip.configurator.toggleColor").string(": ");
        if (this.getTransmitter().getColor() != null) {
            msg.func_150257_a(this.getTransmitter().getColor().getTranslatedColouredComponent());
        } else {
            msg.translation("gui.none");
        }
        player.func_145747_a((ITextComponent)msg);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        super.onRightClick(player, side);
        TextComponentGroup msg = new TextComponentGroup(TextFormatting.GRAY).string("[Mekanism] ", TextFormatting.DARK_BLUE).translation("tooltip.configurator.viewColor").string(": ");
        if (this.getTransmitter().getColor() != null) {
            msg.func_150257_a(this.getTransmitter().getColor().getTranslatedColouredComponent());
        } else {
            msg.translation("gui.none");
        }
        player.func_145747_a((ITextComponent)msg);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumColor getRenderColor() {
        return this.getTransmitter().getColor();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.func_145831_w().field_72995_K) {
            for (TransporterStack stack : this.getTransmitter().getTransit()) {
                TransporterUtils.drop(this.getTransmitter(), stack);
            }
        }
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Void getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    public TransporterImpl getTransmitter() {
        return (TransporterImpl)this.transmitterDelegate;
    }

    public double getCost() {
        return (double)TransporterTier.ULTIMATE.getSpeed() / (double)this.tier.getSpeed();
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = TransporterTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)super.getExtendedState(state)).withProperty((IUnlistedProperty)PropertyColor.INSTANCE, (Object)new PropertyColor(this.getRenderColor()));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY) {
            return (T)Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY.cast((Object)this.getTransmitter());
        }
        return super.getCapability(capability, side);
    }
}

