/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.content.boiler.BoilerSteamTank;
import mekanism.common.content.boiler.BoilerTank;
import mekanism.common.content.boiler.BoilerWaterTank;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing
implements IFluidHandlerWrapper,
IComputerIntegration,
IComparatorSupport {
    private static final String[] methods = new String[]{"isFormed", "getSteam", "getWater", "getBoilRate", "getMaxBoilRate", "getTemp"};
    public BoilerTank waterTank = new BoilerWaterTank(this);
    public BoilerTank steamTank = new BoilerSteamTank(this);
    private int currentRedstoneLevel;

    public TileEntityBoilerValve() {
        super("BoilerValve");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
            int newRedstoneLevel;
            if (((SynchronizedBoilerData)this.structure).steamStored != null && ((SynchronizedBoilerData)this.structure).steamStored.amount > 0) {
                EmitUtils.forEachSide(this.func_145831_w(), this.func_174877_v(), EnumSet.allOf(EnumFacing.class), (tile, side) -> {
                    IFluidHandler handler;
                    if (!(tile instanceof TileEntityBoilerValve) && (handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) != null && PipeUtils.canFill(handler, ((SynchronizedBoilerData)this.structure).steamStored)) {
                        ((SynchronizedBoilerData)this.structure).steamStored.amount -= handler.fill(((SynchronizedBoilerData)this.structure).steamStored, true);
                        if (((SynchronizedBoilerData)this.structure).steamStored.amount <= 0) {
                            ((SynchronizedBoilerData)this.structure).steamStored = null;
                        }
                    }
                });
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
                return new FluidTankInfo[]{this.steamTank.getInfo()};
            }
            return new FluidTankInfo[]{this.waterTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.steamTank.getInfo(), this.waterTank.getInfo()};
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() < ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1 && fluid.getFluid() == FluidRegistry.WATER;
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1 && FluidContainerUtils.canDrain(((SynchronizedBoilerData)this.structure).steamStored, fluid);
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            return new Object[]{this.structure != null};
        }
        if (this.structure == null) {
            return new Object[]{"Unformed"};
        }
        switch (method) {
            case 1: {
                return new Object[]{((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.amount : 0};
            }
            case 2: {
                return new Object[]{((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0};
            }
            case 3: {
                return new Object[]{((SynchronizedBoilerData)this.structure).lastBoilRate};
            }
            case 4: {
                return new Object[]{((SynchronizedBoilerData)this.structure).lastMaxBoil};
            }
            case 5: {
                return new Object[]{((SynchronizedBoilerData)this.structure).temperature};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.waterTank.getFluidAmount(), this.waterTank.getCapacity());
    }
}

