/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.Locale;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;
import net.minecraft.util.IStringSerializable;

public enum EnergyCubeTier implements ITier,
IStringSerializable
{
    BASIC(2000000.0, 800.0),
    ADVANCED(8000000.0, 3200.0),
    ELITE(3.2E7, 12800.0),
    ULTIMATE(1.28E8, 51200.0),
    CREATIVE(Double.MAX_VALUE, Double.MAX_VALUE);

    private final double baseMaxEnergy;
    private final double baseOutput;
    private final BaseTier baseTier;

    private EnergyCubeTier(double max, double out) {
        this.baseMaxEnergy = max;
        this.baseOutput = out;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public double getMaxEnergy() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeMaxEnergy.val();
    }

    public double getOutput() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeOutput.val();
    }

    public double getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public double getBaseOutput() {
        return this.baseOutput;
    }
}

