/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.OreDictCache;
import mekanism.common.util.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MachineInput<INPUT extends MachineInput<INPUT>> {
    public static final ItemStackIngredientMatcher DEFAULT_MATCHER = MachineInput::inputItemMatchesDefault;
    private static final Map<Class<? extends Item>, ItemStackIngredientMatcher> ITEM_MATCHER_OVERRIDES = new HashMap<Class<? extends Item>, ItemStackIngredientMatcher>();

    public static void addCustomItemMatcher(Class<? extends Item> clazz, ItemStackIngredientMatcher matcher) {
        ITEM_MATCHER_OVERRIDES.put(clazz, matcher);
    }

    public static boolean inputContains(ItemStack container, ItemStack contained) {
        if (!container.func_190926_b() && container.func_190916_E() >= contained.func_190916_E()) {
            return MachineInput.inputItemMatches(container, contained);
        }
        return false;
    }

    public abstract boolean isValid();

    public abstract INPUT copy();

    public abstract int hashIngredients();

    public abstract void load(NBTTagCompound var1);

    public abstract boolean testEquality(INPUT var1);

    public static boolean inputItemMatches(ItemStack container, ItemStack contained) {
        return ITEM_MATCHER_OVERRIDES.getOrDefault(container.func_77973_b().getClass(), DEFAULT_MATCHER).test(container, contained);
    }

    private static boolean inputItemMatchesDefault(ItemStack container, ItemStack contained) {
        if (OreDictCache.getOreDictName(container).contains("treeSapling")) {
            return StackUtils.equalsWildcard(container, contained);
        }
        return StackUtils.equalsWildcardWithNBT(container, contained);
    }

    public int hashCode() {
        return this.hashIngredients();
    }

    public boolean equals(Object other) {
        if (this.isInstance(other)) {
            return this.testEquality((MachineInput)other);
        }
        return false;
    }

    public abstract boolean isInstance(Object var1);

    @FunctionalInterface
    public static interface ItemStackIngredientMatcher {
        public boolean test(ItemStack var1, ItemStack var2);
    }
}

