/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.TileEntityFluidTank;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFluidTank
extends TileEntitySpecialRenderer<TileEntityFluidTank> {
    public static final RenderFluidTank INSTANCE = new RenderFluidTank();
    private static FluidRenderMap<MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new FluidRenderMap();
    private static FluidRenderMap<MekanismRenderer.DisplayInteger[]> cachedValveFluids = new FluidRenderMap();
    private static int stages = 1400;

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    public void render(TileEntityFluidTank tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        FluidStack fluid = tileEntity.fluidTank.getFluid();
        this.render(tileEntity.tier, fluid, tileEntity.prevScale, tileEntity.isActive, tileEntity.valve > 0 ? tileEntity.valveFluid : null, x, y, z);
    }

    public void render(FluidTankTier tier, FluidStack fluid, float fluidScale, boolean active, FluidStack valveFluid, double x, double y, double z) {
        if (fluid != null && fluidScale > 0.0f) {
            this.push();
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)x, (double)y, (double)z);
            MekanismRenderer.glowOn(fluid.getFluid().getLuminosity(fluid));
            MekanismRenderer.colorFluid(fluid);
            MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(fluid);
            if (tier == FluidTankTier.CREATIVE) {
                fluidScale = 1.0f;
            }
            if (fluid.getFluid().isGaseous(fluid)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, fluidScale + MekanismRenderer.GAS_RENDER_BASE));
                displayList[stages - 1].render();
            } else {
                displayList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            }
            MekanismRenderer.resetColor();
            MekanismRenderer.glowOff();
            this.pop();
        }
        if (valveFluid != null && !valveFluid.getFluid().isGaseous(valveFluid)) {
            this.push();
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)x, (double)y, (double)z);
            MekanismRenderer.glowOn(valveFluid.getFluid().getLuminosity(valveFluid));
            MekanismRenderer.colorFluid(valveFluid);
            MekanismRenderer.DisplayInteger[] valveList = this.getValveRender(valveFluid);
            valveList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            MekanismRenderer.glowOff();
            MekanismRenderer.resetColor();
            this.pop();
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.blendOff();
        GlStateManager.func_179121_F();
    }

    private void push() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger[] getValveRender(FluidStack fluid) {
        if (cachedValveFluids.containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedValveFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        MekanismRenderer.prepFlowing(toReturn, fluid);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedValveFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                toReturn.minX = 0.3225;
                toReturn.minY = 0.0625 + (double)((float)i / (float)stages) * 0.875;
                toReturn.minZ = 0.3225;
                toReturn.maxX = 0.6775;
                toReturn.maxY = 0.9275;
                toReturn.maxZ = 0.6775;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(FluidStack fluid) {
        if (cachedCenterFluids.containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedCenterFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                toReturn.minX = 0.135;
                toReturn.minY = 0.0725;
                toReturn.minZ = 0.135;
                toReturn.maxX = 0.865;
                toReturn.maxY = 0.0625 + (double)((float)i / (float)stages) * 0.875 - 0.01;
                toReturn.maxZ = 0.865;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }
}

