/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.chemical;

import java.util.Arrays;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.chemical.GuiChemical;
import mekanism.client.gui.element.GuiBucketIO;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChemicalWasher;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalWasher
extends GuiChemical<TileEntityChemicalWasher> {
    public GuiChemicalWasher(InventoryPlayer inventory, TileEntityChemicalWasher tile) {
        super(tile, new ContainerChemicalWasher(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiBucketIO(this, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String usage = MekanismUtils.getEnergyDisplay(((TileEntityChemicalWasher)this.tileEntity).clientEnergyUsed);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + usage + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityChemicalWasher)this.tileEntity).getMaxEnergy() - ((TileEntityChemicalWasher)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).fluidTank, GuiGauge.Type.STANDARD, this, resource, 5, 4));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).inputTank, GuiGauge.Type.STANDARD, this, resource, 26, 13));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).outputTank, GuiGauge.Type.STANDARD, this, resource, 133, 13));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 154, 4).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 154, 55).with(GuiSlot.SlotOverlay.MINUS));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityChemicalWasher)GuiChemicalWasher.this.tileEntity).getActive() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, resource, 62, 38));
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png");
    }

    @Override
    protected void drawForegroundText() {
        this.field_146289_q.func_78276_b(((TileEntityChemicalWasher)this.tileEntity).func_70005_c_(), 45, 4, 0x404040);
    }
}

