/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerResistiveHeater;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater> {
    private GuiTextField energyUsageField;

    public GuiResistiveHeater(InventoryPlayer inventory, TileEntityResistiveHeater tile) {
        super(tile, new ContainerResistiveHeater(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 14, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).getMaxEnergy() - ((TileEntityResistiveHeater)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityResistiveHeater)this.tileEntity).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        String prevEnergyUsage = this.energyUsageField != null ? this.energyUsageField.func_146179_b() : "";
        this.energyUsageField = new GuiTextField(0, this.field_146289_q, guiWidth + 49, guiHeight + 52, 66, 11);
        this.energyUsageField.func_146203_f(7);
        this.energyUsageField.func_146185_a(false);
        this.energyUsageField.func_146180_a(prevEnergyUsage);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tileEntity).temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 50, 25, 52480, 76);
        this.renderScaledText(LangUtils.localize("gui.usage") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage) + "/t", 50, 41, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61) {
            this.func_73729_b(guiWidth + 116, guiHeight + 51, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 116, guiHeight + 51, this.field_146999_f, 11, 11, 11);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.energyUsageField.func_146194_f();
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.func_146179_b().isEmpty()) {
            int toUse = Integer.parseInt(this.energyUsageField.func_146179_b());
            TileNetworkList data = TileNetworkList.withContents(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.energyUsageField.func_146180_a("");
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.energyUsageField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.energyUsageField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 116 && xAxis <= 126 && yAxis >= 51 && yAxis <= 61) {
                this.setEnergyUsage();
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiResistiveHeater.png");
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.energyUsageField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.energyUsageField.func_146206_l() && i == 28) {
            this.setEnergyUsage();
            return;
        }
        if (Character.isDigit(c) || GuiResistiveHeater.isTextboxKey(c, i)) {
            this.energyUsageField.func_146201_a(c, i);
        }
    }
}

