/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ProjectileModifierTrait;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;
import slimeknights.toolleveling.TinkerToolLeveling;
import slimeknights.toolleveling.ToolLevelNBT;
import slimeknights.toolleveling.capability.CapabilityDamageXp;
import slimeknights.toolleveling.capability.IDamageXp;
import slimeknights.toolleveling.config.Config;

public class ModToolLeveling
extends ProjectileModifierTrait {
    public ModToolLeveling() {
        super("toolleveling", 0xFFFFFF);
        this.aspects.clear();
        this.addAspects(new ModifierAspect[]{new ModifierAspect.DataAspect((IModifier)this)});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean canApplyCustom(ItemStack stack) {
        return true;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ToolLevelNBT data = this.getLevelData(modifierTag);
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + data.bonusModifiers;
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
    }

    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (wasEffective && player instanceof EntityPlayer) {
            this.addXp(tool, 1, (EntityPlayer)player);
        }
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (!target.func_130014_f_().field_72995_K && wasHit && player instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            if (!target.func_70089_S()) {
                this.addXp(tool, Math.round(damageDealt), entityPlayer);
            } else if (target.hasCapability(CapabilityDamageXp.CAPABILITY, null)) {
                ((IDamageXp)target.getCapability(CapabilityDamageXp.CAPABILITY, null)).addDamageFromTool(damageDealt, tool, entityPlayer);
            }
        }
    }

    public void onBlock(ItemStack tool, EntityPlayer player, LivingHurtEvent event) {
        if (player != null && !player.field_70170_p.field_72995_K && player.func_184607_cu() == tool) {
            int xp = Math.round(event.getAmount());
            this.addXp(tool, xp, player);
        }
    }

    @SubscribeEvent
    public void onMattock(TinkerToolEvent.OnMattockHoe event) {
        this.addXp(event.itemStack, 1, event.player);
    }

    @SubscribeEvent
    public void onScythe(TinkerToolEvent.OnScytheHarvest event) {
        if (!event.isCanceled()) {
            this.addXp(event.itemStack, 1, event.player);
        }
    }

    @SubscribeEvent
    public void onPath(TinkerToolEvent.OnShovelMakePath event) {
        this.addXp(event.itemStack, 1, event.player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onLivingHurt(LivingAttackEvent event) {
        if (!event.isCanceled()) {
            return;
        }
        if (event.getSource().func_76363_c() || !event.getSource().func_76352_a() || event.getSource().func_76346_g() == null) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!player.func_184585_cz() || player.func_184607_cu().func_77973_b() != TinkerMeleeWeapons.battleSign) {
            return;
        }
        if (ToolHelper.isBroken((ItemStack)player.func_184607_cu())) {
            return;
        }
        int xp = Math.max(1, Math.round(event.getAmount()));
        this.addXp(player.func_184607_cu(), xp, player);
    }

    public void addXp(ItemStack tool, int amount, EntityPlayer player) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)tool);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)this.identifier);
        NBTTagCompound modifierTag = tagList.func_150305_b(index);
        ToolLevelNBT data = this.getLevelData(modifierTag);
        data.xp += amount;
        if (!Config.canLevelUp(data.level)) {
            return;
        }
        int xpForLevelup = this.getXpForLevelup(data.level, tool);
        boolean leveledUp = false;
        if (data.xp >= xpForLevelup) {
            data.xp -= xpForLevelup;
            ++data.level;
            ++data.bonusModifiers;
            leveledUp = true;
        }
        data.write(modifierTag);
        TagUtil.setModifiersTagList((ItemStack)tool, (NBTTagList)tagList);
        if (leveledUp) {
            this.apply(tool);
            if (!player.field_70170_p.field_72995_K) {
                TinkerToolLeveling.proxy.playLevelupDing(player);
                TinkerToolLeveling.proxy.sendLevelUpMessage(data.level, tool, player);
            }
            try {
                NBTTagCompound rootTag = TagUtil.getTagSafe((ItemStack)tool);
                ToolBuilder.rebuildTool((NBTTagCompound)rootTag, (TinkersItem)((TinkersItem)tool.func_77973_b()));
                tool.func_77982_d(rootTag);
            }
            catch (TinkerGuiException e) {
                e.printStackTrace();
            }
        }
    }

    public int getXpForLevelup(int level, ItemStack tool) {
        if (level <= 1) {
            return Config.getBaseXpForTool(tool.func_77973_b());
        }
        return (int)((float)this.getXpForLevelup(level - 1, tool) * Config.getLevelMultiplier());
    }

    private ToolLevelNBT getLevelData(ItemStack itemStack) {
        return this.getLevelData(TinkerUtil.getModifierTag((ItemStack)itemStack, (String)this.getModifierIdentifier()));
    }

    private ToolLevelNBT getLevelData(NBTTagCompound modifierNBT) {
        return new ToolLevelNBT(modifierNBT);
    }

    public void afterHit(EntityProjectileBase projectile, World world, ItemStack ammoStack, EntityLivingBase attacker, Entity target, double impactSpeed) {
        ItemStack launcher;
        if (impactSpeed > (double)0.4f && attacker instanceof EntityPlayer && (launcher = projectile.tinkerProjectile.getLaunchingStack()).func_77973_b() instanceof BowCore) {
            double drawTime = ((BowCore)launcher.func_77973_b()).getDrawTime();
            double drawSpeed = ProjectileLauncherNBT.from((ItemStack)launcher).drawSpeed;
            double drawTimeInSeconds = 1.0 / (20.0 * drawSpeed / drawTime);
            int xp = MathHelper.func_76143_f((double)(5.0 * drawTimeInSeconds));
            this.addXp(launcher, xp, (EntityPlayer)attacker);
        }
    }
}

