/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlazingJuggernaut
extends EntityMob
implements IMultiMob {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;

    public EntityBlazingJuggernaut(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public static void registerFixesBlaze(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityBlazingJuggernaut.class);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.func_130014_f_().field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.func_130014_f_().func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        EntityLivingBase entitylivingbase;
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((entitylivingbase = this.func_70638_az()) != null && entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
            this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_BLAZINGJUGGERNAUT;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    static class AIChargeAttack
    extends EntityAIBase {
        private final EntityBlazingJuggernaut blaze;
        private int attackCooldown;

        public AIChargeAttack(EntityBlazingJuggernaut blazeIn) {
            this.blaze = blazeIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackCooldown = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.blaze.func_70638_az();
            double d0 = this.blaze.func_70068_e((Entity)entitylivingbase);
            ++this.attackCooldown;
            if (d0 < 5.0) {
                if (this.attackCooldown > 10) {
                    this.attackCooldown = 0;
                    this.blaze.func_70652_k((Entity)entitylivingbase);
                }
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
                if (entitylivingbase.field_70163_u < this.blaze.field_70163_u) {
                    this.blaze.field_70181_x -= 0.1;
                }
            } else if (d0 < 30.0) {
                double d1 = entitylivingbase.field_70165_t - this.blaze.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.blaze.field_70163_u + (double)(this.blaze.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.blaze.field_70161_v;
                if (this.attackCooldown > 5) {
                    this.blaze.field_70159_w += (Math.signum(d1) * 0.5 - this.blaze.field_70159_w) * 0.8;
                    this.blaze.field_70181_x += (Math.signum(d2) * (double)0.7f - this.blaze.field_70181_x) * 0.8;
                    this.blaze.field_70179_y += (Math.signum(d3) * 0.5 - this.blaze.field_70179_y) * 0.8;
                    float f = (float)(Math.atan2(this.blaze.field_70179_y, this.blaze.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                    this.blaze.field_191988_bg = 1.5f;
                    this.attackCooldown = 0;
                }
                this.blaze.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            } else {
                this.blaze.func_70661_as().func_75499_g();
                this.blaze.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }
}

