/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.core;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.network.MMNetworkWrapper;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.core.PrimitiveMobsItems;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.core.PrimitiveMobsVillagerProfessions;
import net.daveyx0.primitivemobs.entity.monster.EntityGoblin;
import net.daveyx0.primitivemobs.entity.monster.EntityHarpy;
import net.daveyx0.primitivemobs.entity.monster.EntityHauntedTool;
import net.daveyx0.primitivemobs.entity.monster.EntityMimic;
import net.daveyx0.primitivemobs.entity.monster.EntityRocketCreeper;
import net.daveyx0.primitivemobs.entity.monster.EntitySkeletonWarrior;
import net.daveyx0.primitivemobs.entity.passive.EntityLostMiner;
import net.daveyx0.primitivemobs.entity.passive.EntitySheepman;
import net.daveyx0.primitivemobs.entity.passive.EntityTravelingMerchant;
import net.daveyx0.primitivemobs.item.ItemCamouflageArmor;
import net.daveyx0.primitivemobs.message.MessagePrimitiveJumping;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PrimitiveMobsEvents {

    @Mod.EventBusSubscriber(modid="primitivemobs")
    public static class EntityEventHandler {
        @SubscribeEvent
        public static void spawnEvent(EntityJoinWorldEvent event) {
            EntityVillager villager;
            EntityUtil.removeWhenDisabled((Entity)event.getEntity());
            if (!PrimitiveMobsConfigSpecial.getMinerInVillage() && event.getEntity() instanceof EntityVillager && !(event.getEntity() instanceof EntityLostMiner) && (villager = (EntityVillager)event.getEntity()) != null && villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.MINER_PROFESSION)) {
                EntityEventHandler.replaceVillager(villager);
            }
            if (event.getEntity() instanceof EntityVillager && !(event.getEntity() instanceof EntityTravelingMerchant) && (villager = (EntityVillager)event.getEntity()) != null && (villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.MERCHANT_PROFESSION) || villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.FAKE_MERCHANT_PROFESSION))) {
                EntityEventHandler.replaceVillager(villager);
            }
            if (event.getEntity() instanceof EntityVillager && !(event.getEntity() instanceof EntitySheepman) && (villager = (EntityVillager)event.getEntity()) != null && (villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_ALCHEMIST) || villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_SCAVENGER) || villager.func_70946_n() == VillagerRegistry.getId((VillagerRegistry.VillagerProfession)PrimitiveMobsVillagerProfessions.SHEEPMAN_PROFESSION_THIEF))) {
                EntityEventHandler.replaceVillager(villager);
            }
            if (event.getEntity() instanceof EntityVillager) {
                villager = (EntityVillager)event.getEntity();
                if (event.getEntity() instanceof EntitySheepman) {
                    while (villager.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIAvoidEntity).findFirst().isPresent()) {
                        villager.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIAvoidEntity).findFirst().ifPresent(taskEntry -> villager.field_70714_bg.func_85156_a(taskEntry.field_75733_a));
                    }
                    villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)villager, EntityPigZombie.class, 12.0f, 0.8, 0.8));
                } else {
                    villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)villager, EntityGoblin.class, 8.0f, 0.6, 0.6));
                }
            }
        }

        public static void replaceVillager(EntityVillager villager) {
            int age = villager.func_70874_b();
            EntityVillager replacer = new EntityVillager(villager.field_70170_p);
            replacer.func_70012_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v, villager.field_70177_z, villager.field_70125_A);
            replacer.func_70873_a(age);
            villager.field_70170_p.func_72838_d((Entity)replacer);
            villager.func_70106_y();
        }

        @SubscribeEvent
        public static void onPlayerLogOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
            if (event.player.func_184207_aI()) {
                event.player.func_184226_ay();
                if (event.player instanceof EntityPlayerMP) {
                    MMNetworkWrapper.sendPacket((Entity)event.player, (Packet)new SPacketSetPassengers((Entity)event.player));
                }
            }
        }

        @SubscribeEvent
        public static void onBlockLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
            TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
            if (tileEntity != null && tileEntity instanceof TileEntityChest && !event.getWorld().field_72995_K) {
                TileEntityChest chest = (TileEntityChest)tileEntity;
                NBTTagCompound compound = chest.getTileData();
                boolean isEmpty = true;
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    if (chest.func_70301_a(i).func_190926_b()) continue;
                    isEmpty = false;
                }
                if (event.getEntityPlayer().func_184812_l_() && isEmpty && event.getEntityPlayer().func_184614_ca() != null && event.getEntityPlayer().func_184614_ca().func_77973_b() == PrimitiveMobsItems.MIMIC_ORB && chest.field_145991_k == null && chest.field_145990_j == null && chest.field_145992_i == null && chest.field_145988_l == null) {
                    EntityEventHandler.consumeItemFromStack(event.getEntityPlayer(), event.getEntityPlayer().func_184614_ca());
                    compound.func_74768_a("Mimic", 1);
                    MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), 10, (float)event.getPos().func_177958_n() + 0.05f, (float)event.getPos().func_177956_o() + 0.05f, (float)event.getPos().func_177952_p() + 0.05f, 0.0, 0.01, 0.0, 0));
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
            TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
            if (tileEntity != null && tileEntity instanceof TileEntityChest && !event.getWorld().field_72995_K) {
                TileEntityChest chest = (TileEntityChest)tileEntity;
                NBTTagCompound compound = chest.getTileData();
                if (compound.func_74764_b("Mimic")) {
                    if (compound.func_74762_e("Mimic") != 0) {
                        boolean flag1;
                        int chance = event.getWorld().field_73012_v.nextInt(3);
                        boolean flag = chance == 0 || compound.func_74762_e("Mimic") == 2;
                        boolean bl = flag1 = chance == 1;
                        if (flag && chest.field_145991_k == null && chest.field_145990_j == null && chest.field_145992_i == null && chest.field_145988_l == null) {
                            EntityMimic mimic = new EntityMimic(event.getWorld());
                            mimic.func_70012_b((double)event.getPos().func_177958_n() + 0.5, event.getPos().func_177956_o(), (double)event.getPos().func_177952_p() + 0.5, 180.0f, 0.0f);
                            mimic.setChest(event.getWorld().func_180495_p(event.getPos()));
                            event.getWorld().func_72838_d((Entity)mimic);
                            if (compound.func_74762_e("Mimic") != 2 && event.getWorld().field_73012_v.nextInt(10) == 0) {
                                mimic.setToExplode();
                            }
                            event.getWorld().func_175698_g(event.getPos());
                            event.setCanceled(true);
                            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.CLOUD.func_179348_c(), 10, (float)event.getPos().func_177958_n() + 0.05f, (float)event.getPos().func_177956_o() + 0.05f, (float)event.getPos().func_177952_p() + 0.05f, 0.0, 0.0, 0.0, 0));
                        } else if (flag1 && chest.field_145991_k == null && chest.field_145990_j == null && chest.field_145992_i == null && chest.field_145988_l == null) {
                            int option = event.getWorld().field_73012_v.nextInt(4);
                            if (option == 0) {
                                EntitySkeletonWarrior skeleton = new EntitySkeletonWarrior(event.getWorld());
                                skeleton.func_180482_a(event.getWorld().func_175649_E(new BlockPos((Entity)skeleton)), null);
                                skeleton.func_70012_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 1.0, (double)event.getPos().func_177952_p() + 0.5, 180.0f, 0.0f);
                                event.getWorld().func_72838_d((Entity)skeleton);
                            } else if (option == 1) {
                                for (int i = 0; i < 3; ++i) {
                                    EntityBat bat = new EntityBat(event.getWorld());
                                    bat.func_70012_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 1.0, (double)event.getPos().func_177952_p() + 0.5, 180.0f, 0.0f);
                                    event.getWorld().func_72838_d((Entity)bat);
                                }
                            } else {
                                EntityHauntedTool tool = new EntityHauntedTool(event.getWorld());
                                tool.func_180482_a(event.getWorld().func_175649_E(new BlockPos((Entity)tool)), null);
                                tool.func_70012_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 1.0, (double)event.getPos().func_177952_p() + 0.5, 180.0f, 0.0f);
                                event.getWorld().func_72838_d((Entity)tool);
                            }
                            chest.func_189404_a(PrimitiveMobsLootTables.MIMIC_TRAP, event.getWorld().field_73012_v.nextLong());
                            compound.func_74768_a("Mimic", 0);
                            event.setCanceled(true);
                            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.CLOUD.func_179348_c(), 10, (float)event.getPos().func_177958_n() + 0.5f, (float)event.getPos().func_177956_o() + 0.5f, (float)event.getPos().func_177952_p() + 0.5f, 0.0, 0.0, 0.0, 0));
                        } else if (chest.field_145991_k == null && chest.field_145990_j == null && chest.field_145992_i == null && chest.field_145988_l == null) {
                            chest.func_189404_a(PrimitiveMobsLootTables.MIMIC_TREASURE, event.getWorld().field_73012_v.nextLong());
                            compound.func_74768_a("Mimic", 0);
                        }
                    }
                } else {
                    boolean isEmpty = true;
                    for (int i = 0; i < chest.func_70302_i_(); ++i) {
                        if (chest.func_70301_a(i).func_190926_b()) continue;
                        isEmpty = false;
                    }
                    if (isEmpty && event.getEntityPlayer().func_184614_ca() != null && event.getEntityPlayer().func_184614_ca().func_77973_b() == PrimitiveMobsItems.MIMIC_ORB && chest.field_145991_k == null && chest.field_145990_j == null && chest.field_145992_i == null && chest.field_145988_l == null) {
                        EntityEventHandler.consumeItemFromStack(event.getEntityPlayer(), event.getEntityPlayer().func_184614_ca());
                        compound.func_74768_a("Mimic", 2);
                        MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.CLOUD.func_179348_c(), 10, (float)event.getPos().func_177958_n() + 0.5f, (float)event.getPos().func_177956_o() + 0.5f, (float)event.getPos().func_177952_p() + 0.5f, 0.0, 0.0, 0.0, 0));
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            if (entityLiving != null && entityLiving.field_70173_aa % 5 == 0) {
                EntityPlayer player;
                ItemCamouflageArmor.setCamouflageArmorNBT(entityLiving, EntityEquipmentSlot.CHEST);
                ItemCamouflageArmor.setCamouflageArmorNBT(entityLiving, EntityEquipmentSlot.FEET);
                ItemCamouflageArmor.setCamouflageArmorNBT(entityLiving, EntityEquipmentSlot.HEAD);
                ItemCamouflageArmor.setCamouflageArmorNBT(entityLiving, EntityEquipmentSlot.LEGS);
                if (entityLiving.field_70170_p.field_73012_v.nextInt(50) == 0 && entityLiving instanceof EntityPlayer && EntityEventHandler.hasFullCamouflageArmor(player = (EntityPlayer)entityLiving)) {
                    entityLiving.func_130014_f_().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entityLiving.field_70165_t + (double)(event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() - entityLiving.field_70170_p.field_73012_v.nextFloat()), entityLiving.field_70163_u + (double)entityLiving.field_70170_p.field_73012_v.nextFloat() + 1.0, entityLiving.field_70161_v + (double)(entityLiving.field_70170_p.field_73012_v.nextFloat() - entityLiving.field_70170_p.field_73012_v.nextFloat()), 1.0, 1.0, 1.0, new int[0]);
                }
            }
        }

        @SubscribeEvent
        public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            if (entityLiving != null && (entityLiving instanceof EntityZombie || entityLiving instanceof AbstractIllager || entityLiving instanceof EntityGoblin)) {
                EntityMob mob = (EntityMob)entityLiving;
                if (event.getTarget() instanceof EntitySheepman) {
                    mob.func_70624_b(null);
                }
            }
            if (event.getTarget() != null && event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving) {
                EntityPlayer player = (EntityPlayer)event.getTarget();
                EntityLiving living = (EntityLiving)event.getEntityLiving();
                if (living.func_110144_aD() != player && living.func_94060_bK() != player && EntityEventHandler.hasFullCamouflageArmor(player) && living.func_70068_e((Entity)player) > 36.0) {
                    living.func_70624_b(null);
                } else {
                    living.func_130011_c((Entity)player);
                }
            }
        }

        public static boolean hasFullCamouflageArmor(EntityPlayer player) {
            int amountOfPieces = 0;
            Iterable equipment = player.func_184209_aF();
            for (ItemStack stack : equipment) {
                if (stack.func_77973_b() != PrimitiveMobsItems.CAMOUFLAGE_BOOTS && stack.func_77973_b() != PrimitiveMobsItems.CAMOUFLAGE_CHEST && stack.func_77973_b() != PrimitiveMobsItems.CAMOUFLAGE_HELMET && stack.func_77973_b() != PrimitiveMobsItems.CAMOUFLAGE_LEGS) continue;
                ++amountOfPieces;
            }
            return amountOfPieces == 4;
        }

        protected static void consumeItemFromStack(EntityPlayer player, ItemStack stack) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }

        @SubscribeEvent
        public void onLivingFall(LivingFallEvent event) {
            if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityRocketCreeper) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onEntityAttacked(LivingAttackEvent event) {
            EntityLivingBase sourceEntity;
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (sourceEntity = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() == PrimitiveMobsItems.GOBLIN_MACE) {
                ArrayList<ItemStack> damageableArmorPieces = new ArrayList<ItemStack>();
                Iterable armorPieces = event.getEntityLiving().func_184193_aE();
                if (armorPieces != null && !armorPieces.equals(Collections.emptyList())) {
                    for (ItemStack piece : event.getEntityLiving().func_184193_aE()) {
                        if (piece.func_190926_b() || !piece.func_77984_f()) continue;
                        damageableArmorPieces.add(piece);
                    }
                    if (!damageableArmorPieces.isEmpty()) {
                        ItemStack targetPiece = (ItemStack)damageableArmorPieces.get(event.getEntityLiving().func_70681_au().nextInt(damageableArmorPieces.size()));
                        targetPiece.func_77972_a((int)((float)targetPiece.func_77958_k() * 0.1f), event.getEntityLiving());
                    }
                }
            }
        }

        @Nullable
        public EntityEquipmentSlot getSlotFromItemStack(EntityLivingBase entityIn, ItemStack stack) {
            if (entityIn != null && !stack.func_190926_b()) {
                if (stack.func_77973_b() == entityIn.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()) {
                    return EntityEquipmentSlot.HEAD;
                }
                if (stack.func_77973_b() == entityIn.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()) {
                    return EntityEquipmentSlot.CHEST;
                }
                if (stack.func_77973_b() == entityIn.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b()) {
                    return EntityEquipmentSlot.LEGS;
                }
                if (stack.func_77973_b() == entityIn.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b()) {
                    return EntityEquipmentSlot.FEET;
                }
            }
            return null;
        }

        @SubscribeEvent
        public static void DismountPlayerEvent(EntityMountEvent event) {
            if (event.isDismounting() && event.getEntityBeingMounted() != null && event.getEntityBeingMounted() instanceof EntityHarpy && event.getEntityMounting() != null && event.getEntityMounting().func_70093_af() && event.getEntityMounting() instanceof EntityPlayer) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void PlayEntitySound(PlaySoundAtEntityEvent event) {
            if (event.getVolume() == 1.1111f) {
                EntitySheepman sheepman = (EntitySheepman)event.getEntity();
                if (event.getSound() == SoundEvents.field_187915_go) {
                    event.setSound(SoundEvents.field_187757_eG);
                } else if (event.getSound() == SoundEvents.field_187913_gm) {
                    event.setSound(SoundEvents.field_187761_eI);
                }
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onKeyInput(InputEvent.KeyInputEvent event) {
            if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                String UUID2 = Minecraft.func_71410_x().field_71439_g.func_110124_au().toString();
                MMMessageRegistry.getNetwork().sendToServer((IMessage)new MessagePrimitiveJumping(UUID2));
            }
        }
    }
}

