/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.client;

import com.viesis.viescraft.api.EnumsVC;
import com.viesis.viescraft.api.ItemsVC;
import com.viesis.viescraft.init.InitItemsVC;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="vc")
public final class InitItemsVCRender
extends ItemsVC {
    public static final InitItemsVCRender INSTANCE = new InitItemsVCRender();
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerItemRender();
    }

    private void registerItemRender() {
        this.registerRender(InitItemsVC.GUIDEBOOK_MAIN);
        InitItemsVC.RegistrationHandler.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerRender);
        for (EnumsVC.ModuleType moduleType : EnumsVC.ModuleType.values()) {
            this.registerRenderModuleType(MODULE_TYPE, moduleType.getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainTierCore.values()) {
            this.registerRenderTierCore(UPGRADE_CORE, ((EnumsVC.MainTierCore)enum_).getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainTierFrame.values()) {
            this.registerRenderTierFrame(UPGRADE_FRAME, ((EnumsVC.MainTierFrame)enum_).getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainTierEngine.values()) {
            this.registerRenderTierEngine(UPGRADE_ENGINE, ((EnumsVC.MainTierEngine)enum_).getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainTierBalloon.values()) {
            this.registerRenderTierBalloon(UPGRADE_BALLOON, ((EnumsVC.MainTierBalloon)enum_).getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainTierCore.values()) {
            this.registerRenderTierCore(ITEM_AIRSHIP, ((EnumsVC.MainTierCore)enum_).getMetadata());
        }
        this.registerRender(ITEM_AIRSHIP_CREATIVE);
        for (Enum enum_ : EnumsVC.Bombs.values()) {
            this.registerRenderBomb(BOMB, ((EnumsVC.Bombs)enum_).getMetadata());
        }
        for (Enum enum_ : EnumsVC.MainDisplaySymbol.values()) {
            this.registerRenderDisplaySymbol(ITEM_DISPLAY_SYMBOL, ((EnumsVC.MainDisplaySymbol)enum_).getMetadata());
        }
        this.registerRender(ITEM_ENTITY_AIRSHIP);
        for (Enum enum_ : EnumsVC.Achievement.values()) {
            this.registerRenderAchievement(ACHIEVEMENT_AIRSHIP, ((EnumsVC.Achievement)enum_).getMetadata());
        }
    }

    private static void registerItemRenderTEMP() {
    }

    private void registerRender(Item item) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    private void registerRenderTierCore(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.MainTierCore.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderTierFrame(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.MainTierFrame.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderTierEngine(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.MainTierEngine.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderTierBalloon(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.MainTierBalloon.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderModuleType(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.ModuleType.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderDisplaySymbol(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.MainDisplaySymbol.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderAchievement(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.Achievement.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }

    private void registerRenderBomb(Item item, int meta) {
        String itemName = item.getRegistryName().toString() + "_" + EnumsVC.Bombs.byId(meta).getRegistryName().toString().toLowerCase().replaceAll("\\s+", "");
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemName, "inventory"));
    }
}

