/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.item.storagesack.BagDepositReturn;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UtilInventoryTransfer {
    public static ArrayList<ItemStack> dumpToIInventory(List<ItemStack> stacks, IInventory inventory, int startingSlot, int maxSlot) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack current : stacks) {
            for (int i = startingSlot; i < maxSlot; ++i) {
                int space;
                int toDeposit;
                if (current.func_190926_b()) continue;
                ItemStack chestStack = inventory.func_70301_a(i);
                if (chestStack.func_190926_b()) {
                    inventory.func_70299_a(i, current);
                    current = ItemStack.field_190927_a;
                    continue;
                }
                if (!UtilItemStack.canMerge(chestStack, current) || (toDeposit = Math.min(space = chestStack.func_77976_d() - chestStack.func_190916_E(), current.func_190916_E())) <= 0) continue;
                current.func_190918_g(toDeposit);
                chestStack.func_190917_f(toDeposit);
                if (current.func_190916_E() != 0) continue;
                current = ItemStack.field_190927_a;
            }
            if (current.func_190926_b()) continue;
            remaining.add(current);
        }
        return remaining;
    }

    public static ArrayList<ItemStack> dumpToIInventory(List<ItemStack> stacks, IInventory inventory, int startingSlot) {
        return UtilInventoryTransfer.dumpToIInventory(stacks, inventory, startingSlot, inventory.func_70302_i_());
    }

    public static BagDepositReturn dumpFromListToCapability(World world, TileEntity tile, EnumFacing side, NonNullList<ItemStack> stacks, boolean onlyMatchingItems) {
        int itemsMoved = 0;
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return new BagDepositReturn(itemsMoved, stacks);
        }
        IItemHandler chest = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        for (int islotStacks = 0; islotStacks < stacks.size(); ++islotStacks) {
            ItemStack bagItem = (ItemStack)stacks.get(islotStacks);
            if (bagItem.func_190926_b() || bagItem.func_190916_E() == 0) continue;
            for (int islotChest = 0; islotChest < chest.getSlots(); ++islotChest) {
                if (onlyMatchingItems && !UtilItemStack.canMerge(bagItem, chest.getStackInSlot(islotChest))) continue;
                int before = bagItem.func_190916_E();
                bagItem = chest.insertItem(islotChest, bagItem, false);
                stacks.set(islotStacks, (Object)bagItem);
                itemsMoved += before - bagItem.func_190916_E();
            }
        }
        return new BagDepositReturn(itemsMoved, stacks);
    }

    public static BagDepositReturn dumpFromListToIInventory(World world, IInventory chest, NonNullList<ItemStack> stacks, boolean onlyMatchingItems) {
        int itemsMoved = 0;
        block0: for (int islotStacks = 0; islotStacks < stacks.size(); ++islotStacks) {
            ItemStack bagItem = (ItemStack)stacks.get(islotStacks);
            if (bagItem.func_190926_b() || bagItem.func_190916_E() == 0) continue;
            for (int islotChest = 0; islotChest < chest.func_70302_i_(); ++islotChest) {
                ItemStack chestItem = chest.func_70301_a(islotChest);
                if (chestItem.func_190926_b() && !onlyMatchingItems) {
                    if (!chest.func_94041_b(islotStacks, bagItem)) continue;
                    itemsMoved += bagItem.func_190916_E();
                    chest.func_70299_a(islotChest, bagItem);
                    stacks.set(islotStacks, (Object)ItemStack.field_190927_a);
                    bagItem = ItemStack.field_190927_a;
                    continue block0;
                }
                if (chestItem.func_190926_b()) continue;
                if (UtilItemStack.isEmpty(bagItem)) continue block0;
                bagItem = (ItemStack)stacks.get(islotStacks);
                if (UtilItemStack.canMerge(bagItem, chestItem)) {
                    int chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem);
                    int room = chestMax - chestItem.func_190916_E();
                    if (room <= 0) continue;
                    int toDeposit = Math.min(bagItem.func_190916_E(), room);
                    chestItem.func_190917_f(toDeposit);
                    chest.func_70299_a(islotChest, chestItem);
                    bagItem.func_190918_g(toDeposit);
                    itemsMoved += toDeposit;
                    if (bagItem.func_190916_E() <= 0) {
                        stacks.set(islotStacks, (Object)ItemStack.field_190927_a);
                    } else {
                        stacks.set(islotStacks, (Object)bagItem);
                    }
                }
                if (UtilItemStack.isEmpty(bagItem)) continue block0;
            }
        }
        return new BagDepositReturn(itemsMoved, stacks);
    }
}

