/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.minecart;

import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BehaviorMinecartDropItem
implements IBehaviorDispenseItem {
    public final ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        ItemStack itemstack = this.dispenseStack(source, stack);
        this.playDispenseSound(source);
        this.spawnDispenseParticles(source, this.getFacing(source));
        return itemstack;
    }

    public EnumFacing getFacing(IBlockSource state) {
        return this.getFacing(state.func_189992_e());
    }

    public EnumFacing getFacing(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150408_cc) {
            BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)BlockRailPowered.field_176568_b);
            switch (dir) {
                case ASCENDING_EAST: {
                    return EnumFacing.EAST;
                }
                case ASCENDING_NORTH: {
                    return EnumFacing.NORTH;
                }
                case ASCENDING_SOUTH: {
                    return EnumFacing.SOUTH;
                }
                case ASCENDING_WEST: {
                    return EnumFacing.WEST;
                }
                case EAST_WEST: {
                    return EnumFacing.NORTH;
                }
                case NORTH_EAST: {
                    return EnumFacing.SOUTH;
                }
                case NORTH_SOUTH: {
                    return EnumFacing.WEST;
                }
                case NORTH_WEST: {
                    return EnumFacing.EAST;
                }
                case SOUTH_EAST: {
                    return EnumFacing.NORTH;
                }
                case SOUTH_WEST: {
                    return EnumFacing.EAST;
                }
            }
        }
        return EnumFacing.NORTH;
    }

    protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        EnumFacing enumfacing = this.getFacing(source);
        IPosition iposition = this.getDispensePosition(source);
        ItemStack itemstack = stack.func_77979_a(1);
        BehaviorMinecartDropItem.doDispense(source.func_82618_k(), itemstack, 6, enumfacing, iposition);
        return stack;
    }

    public IPosition getDispensePosition(IBlockSource coords) {
        EnumFacing enumfacing = this.getFacing(coords.func_189992_e());
        double d0 = coords.func_82615_a() + 0.7 * (double)enumfacing.func_82601_c();
        double d1 = coords.func_82617_b() + 0.7 * (double)enumfacing.func_96559_d();
        double d2 = coords.func_82616_c() + 0.7 * (double)enumfacing.func_82599_e();
        return new PositionImpl(d0, d1, d2);
    }

    public static void doDispense(World worldIn, ItemStack stack, int speed, EnumFacing facing, IPosition position) {
        double d0 = position.func_82615_a();
        double d1 = position.func_82617_b();
        double d2 = position.func_82616_c();
        d1 = facing.func_176740_k() == EnumFacing.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        EntityItem entityitem = new EntityItem(worldIn, d0, d1, d2, stack);
        double d3 = worldIn.field_73012_v.nextDouble() * 0.1 + 0.2;
        entityitem.field_70159_w = (double)facing.func_82601_c() * d3;
        entityitem.field_70181_x = 0.2f;
        entityitem.field_70179_y = (double)facing.func_82599_e() * d3;
        entityitem.field_70159_w += worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed;
        entityitem.field_70181_x += worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed;
        entityitem.field_70179_y += worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed;
        worldIn.func_72838_d((Entity)entityitem);
    }

    protected void playDispenseSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
    }

    protected void spawnDispenseParticles(IBlockSource source, EnumFacing facingIn) {
        source.func_82618_k().func_175718_b(2000, source.func_180699_d(), this.getWorldEventDataFrom(facingIn));
    }

    private int getWorldEventDataFrom(EnumFacing facingIn) {
        return facingIn.func_82601_c() + 1 + (facingIn.func_82599_e() + 1) * 3;
    }
}

