/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import com.lothrazar.cyclicmagic.command.BaseCommand;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandSearchItem
extends BaseCommand
implements ICommand {
    public static final String name = "searchitem";
    public static final int radius = 64;

    public CommandSearchItem(boolean op) {
        super(name, op);
    }

    @Override
    public String func_71518_a(ICommandSender arg0) {
        return "/" + this.func_71517_b() + " <item>";
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            UtilChat.addChatMessage(sender, this.func_71518_a(sender));
            return;
        }
        String searchQuery = String.join((CharSequence)" ", Arrays.asList(args));
        if (searchQuery.length() == 0) {
            UtilChat.addChatMessage(sender, this.func_71518_a(sender));
        }
        Map<IInventory, BlockPos> tilesToSearch = UtilWorld.findTileEntityInventories(sender, 64);
        ArrayList<String> foundMessages = new ArrayList<String>();
        for (Map.Entry<IInventory, BlockPos> entry : tilesToSearch.entrySet()) {
            int foundQtyTotal = 0;
            foundQtyTotal = UtilWorld.searchTileInventory(searchQuery, entry.getKey());
            if (foundQtyTotal <= 0) continue;
            String totalsStr = foundQtyTotal + " : ";
            foundMessages.add(totalsStr + CommandSearchItem.getCoordsOrReduced(sender, entry.getValue()));
        }
        int ifound = foundMessages.size();
        if (ifound == 0) {
            UtilChat.addChatMessage(sender, UtilChat.lang("command.searchitem.none") + " : " + 64);
        } else {
            for (int i = 0; i < ifound; ++i) {
                UtilChat.addChatMessage(sender, (String)foundMessages.get(i));
            }
        }
    }

    public static String getCoordsOrReduced(ICommandSender player, BlockPos pos) {
        return UtilChat.getDirectionsString(player, pos) + " (" + UtilChat.blockPosToString(pos) + ")";
    }
}

