/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.solidifier;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeSolidifier
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final int FLUID_DEFAULT = 25;
    public static ArrayList<RecipeSolidifier> recipes = new ArrayList();
    private NonNullList<ItemStack> recipeInput = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private ItemStack resultItem = ItemStack.field_190927_a;
    private int fluidCost = 25;
    private String fluidString;
    Fluid fluidResult;
    private int size = 0;

    public RecipeSolidifier(ItemStack[] in, ItemStack out, String fluidName, int fluid) {
        this.fluidString = fluidName;
        this.setFluidResult(FluidRegistry.getFluid((String)fluidName));
        if (in.length > 4 || in.length == 0) {
            throw new IllegalArgumentException("Input array must be length 4 or less");
        }
        for (ItemStack itemStack : in) {
            if (itemStack == null || itemStack.func_190926_b()) continue;
            this.recipeInput.set(this.size, (Object)itemStack);
            ++this.size;
        }
        this.fluidCost = fluid;
        this.resultItem = out;
        this.setRegistryName(new ResourceLocation("cyclicmagic", "solidifier_" + UUID.randomUUID().toString() + out.func_77977_a()));
    }

    public FluidStack getFluidIngredient() {
        return new FluidStack(this.fluidResult, this.fluidCost);
    }

    public void setFluidResult(Fluid fluidResult) {
        this.fluidResult = fluidResult;
    }

    public int getSize() {
        return this.size;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        this.sanityCheckInput();
        int countFull = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++countFull;
        }
        if (countFull != this.size) {
            return false;
        }
        boolean match0 = RecipeSolidifier.recipeSlotMatches(inv.func_70301_a(0), (ItemStack)this.recipeInput.get(0));
        boolean match1 = RecipeSolidifier.recipeSlotMatches(inv.func_70301_a(1), (ItemStack)this.recipeInput.get(1));
        boolean match2 = RecipeSolidifier.recipeSlotMatches(inv.func_70301_a(2), (ItemStack)this.recipeInput.get(2));
        boolean match3 = RecipeSolidifier.recipeSlotMatches(inv.func_70301_a(3), (ItemStack)this.recipeInput.get(3));
        boolean all = match0 && match1 && match2 && match3;
        return all;
    }

    private void sanityCheckInput() {
        for (int i = 0; i < this.recipeInput.size(); ++i) {
            ItemStack s = (ItemStack)this.recipeInput.get(i);
            if (s.func_190926_b() || s.func_77960_j() != Short.MAX_VALUE) continue;
            ItemStack snew = new ItemStack(s.func_77973_b(), 1, 0);
            snew.func_77982_d(s.func_77978_p());
            this.recipeInput.set(i, (Object)snew);
        }
    }

    public static boolean recipeSlotMatches(ItemStack sInvo, ItemStack sRecipe) {
        if (sInvo.func_190926_b() != sRecipe.func_190926_b()) {
            return false;
        }
        return sInvo.func_190916_E() >= sRecipe.func_190916_E() && (sInvo.func_77969_a(sRecipe) || OreDictionary.itemMatches((ItemStack)sInvo, (ItemStack)sRecipe, (boolean)false));
    }

    public boolean tryPayCost(IInventory invoSource, FluidTank tank, boolean keepOneMinimum) {
        int i;
        if (tank.getFluidAmount() < this.getFluidCost() || tank.getFluid() == null || tank.getFluid().getFluid() != this.fluidResult) {
            return false;
        }
        int minimum = keepOneMinimum ? 2 : 1;
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b() || invoSource.func_70301_a(i).func_190916_E() >= ((ItemStack)this.recipeInput.get(i)).func_190916_E() + (minimum - 1)) continue;
            return false;
        }
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b()) continue;
            invoSource.func_70298_a(i, ((ItemStack)this.recipeInput.get(i)).func_190916_E());
        }
        tank.drain(this.getFluidCost(), true);
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.resultItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width <= 2 && height <= 2;
    }

    public ItemStack func_77571_b() {
        return this.resultItem.func_77946_l();
    }

    public List<ItemStack> getRecipeInput() {
        return this.recipeInput;
    }

    public int getFluidCost() {
        return this.fluidCost;
    }

    public void setFluidCost(int fluidCost) {
        this.fluidCost = fluidCost;
    }

    public static void initAllRecipes() {
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151055_y)}, new ItemStack(Blocks.field_150432_aD), "water", 1000));
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151055_y)}, new ItemStack(Blocks.field_150343_Z), "lava", 1000));
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151133_ar)}, new ItemStack(Items.field_151117_aB), "milk", 1000));
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151032_g)}, PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185219_B), "poison", 100));
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151145_ak)}, PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i, 3), (PotionType)PotionTypes.field_185253_y), "lava", 500));
        Item amber = Item.func_111206_d((String)"cyclicmagic:crystallized_amber");
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151074_bl)}, new ItemStack(amber), "amber", 1000));
        Item crystal = Item.func_111206_d((String)"cyclicmagic:crystallized_obsidian");
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_191525_da)}, new ItemStack(crystal), "crystal", 1000));
        Item biomass = Item.func_111206_d((String)"cyclicmagic:peat_biomass");
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151014_N)}, new ItemStack(biomass), "biomass", 1000));
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Items.field_151034_e)}, new ItemStack(biomass), "biomass", 800));
        Item peat = Item.func_111206_d((String)"cyclicmagic:peat_unbaked");
        RecipeSolidifier.addRecipe(new RecipeSolidifier(new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d)}, new ItemStack(peat, 2), "biomass", 100));
    }

    public static void addRecipe(RecipeSolidifier rec) {
        recipes.add(rec);
    }

    public String getFluidString() {
        return this.fluidString;
    }

    public void setFluidString(String fluidString) {
        this.fluidString = fluidString;
    }
}

