/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary.ctrl;

import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.enchantlibrary.EnchantStorageTarget;
import com.lothrazar.cyclicmagic.block.enchantlibrary.ctrl.TileEntityLibraryCtrl;
import com.lothrazar.cyclicmagic.block.enchantlibrary.shelf.TileEntityLibrary;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.data.QuadrantEnum;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockLibraryController
extends BlockBaseHasTile
implements IHasRecipe {
    private static final int RANGE = 4;
    @GameRegistry.ObjectHolder(value="cyclicmagic:block_library")
    static Block libraryInstance;

    public BlockLibraryController() {
        super(Material.field_151575_d);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityLibraryCtrl();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerHeld = player.func_184586_b(hand);
        if (!playerHeld.func_77973_b().equals(Items.field_151134_bR)) {
            return false;
        }
        if (playerHeld.func_190916_E() != 1) {
            if (world.field_72995_K) {
                UtilChat.addChatMessage(player, "block_library.stacksize");
            }
            return false;
        }
        EnchantStorageTarget target = BlockLibraryController.findMatchingTarget(world, pos, playerHeld);
        if (!target.isEmpty()) {
            ItemStack theThing = target.library.addEnchantmentToQuadrant(playerHeld, target.quad);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            if (!theThing.func_190926_b()) {
                player.func_191521_c(theThing);
            } else {
                player.func_191521_c(new ItemStack(Items.field_151122_aG));
            }
            target.library.func_70296_d();
            world.func_175646_b(target.library.func_174877_v(), (TileEntity)target.library);
            return true;
        }
        return false;
    }

    public static EnchantStorageTarget findMatchingTarget(World world, BlockPos pos, ItemStack playerHeld) {
        TileEntityLibrary lib;
        QuadrantEnum quad;
        TileEntity te;
        EnchantStorageTarget target = new EnchantStorageTarget();
        if (!playerHeld.func_77973_b().equals(Items.field_151134_bR)) {
            return target;
        }
        List<BlockPos> connectors = UtilWorld.getMatchingInRange(world, pos, libraryInstance, 4);
        for (BlockPos p : connectors) {
            te = world.func_175625_s(p);
            if (!(te instanceof TileEntityLibrary) || (quad = (lib = (TileEntityLibrary)te).findMatchingQuadrant(playerHeld, lib)) == null) continue;
            target.library = lib;
            target.quad = quad;
            break;
        }
        if (target.library == null) {
            for (BlockPos p : connectors) {
                te = world.func_175625_s(p);
                if (!(te instanceof TileEntityLibrary)) continue;
                lib = (TileEntityLibrary)te;
                quad = lib.findMatchingQuadrant(playerHeld, lib);
                if (quad == null) {
                    quad = lib.findEmptyQuadrant();
                }
                if (quad == null) continue;
                target.library = lib;
                target.quad = quad;
                break;
            }
        }
        return target;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), " r ", "rgr", " r ", Character.valueOf('g'), "chestEnder", Character.valueOf('r'), libraryInstance);
    }
}

