/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.clockredstone;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.clockredstone.TileEntityClock;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneClock
extends BlockBaseHasTile
implements IHasRecipe,
IContent {
    private static final int PARTICLE_DENSITY = 2;
    public static final PropertyBool POWERED = BlockLever.field_176359_b;
    private static final PropertyBool U = PropertyBool.func_177716_a((String)"u");
    private static final PropertyBool D = PropertyBool.func_177716_a((String)"d");
    private static final PropertyBool N = PropertyBool.func_177716_a((String)"n");
    private static final PropertyBool E = PropertyBool.func_177716_a((String)"e");
    private static final PropertyBool S = PropertyBool.func_177716_a((String)"s");
    private static final PropertyBool W = PropertyBool.func_177716_a((String)"w");
    private boolean enabled;

    public BlockRedstoneClock() {
        super(Material.field_151573_f);
        this.setGuiId(25);
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCK);
        BlockRegistry.registerTileEntity(TileEntityClock.class, this.getContentName() + "_te");
    }

    @Override
    public String getContentName() {
        return "clock";
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("Clock", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, U, D, N, E, S, W});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityClock();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue()) {
            UtilParticle.spawnParticle(worldIn, EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2);
        }
    }

    private int getPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_175625_s(pos) instanceof TileEntityClock) {
            TileEntityClock clock = (TileEntityClock)world.func_175625_s(pos);
            return clock.getPowerForSide(side);
        }
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityClock) {
            TileEntityClock clock = (TileEntityClock)tile;
            try {
                boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
                state = state.func_177226_a((IProperty)U, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.UP) && powered));
                state = state.func_177226_a((IProperty)D, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.DOWN) && powered));
                state = state.func_177226_a((IProperty)N, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.NORTH) && powered));
                state = state.func_177226_a((IProperty)E, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.EAST) && powered));
                state = state.func_177226_a((IProperty)S, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.SOUTH) && powered));
                state = state.func_177226_a((IProperty)W, (Comparable)Boolean.valueOf(clock.getSideHasPower(EnumFacing.WEST) && powered));
            }
            catch (Exception e) {
                ModCyclic.logger.error("fail clock getActualState", e);
            }
        }
        return super.func_176221_a(state, world, pos);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "iri", "rqr", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('q'), Items.field_151107_aW);
    }
}

