/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.batterycell;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.battery.ItemBlockBattery;
import com.lothrazar.cyclicmagic.block.batterycell.TileEntityBatteryCell;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBatteryCell
extends BlockBaseHasTile
implements IHasRecipe,
IContent {
    public static final int MAX_SMALL = 1000000;
    public static final int MAX_MED = 16000000;
    public static final int MAX_LRG = 64000000;
    private int capacity;
    private boolean enabled;

    public BlockBatteryCell(int capacity) {
        super(Material.field_151576_e);
        this.capacity = capacity;
    }

    @Override
    public String getContentName() {
        return "battery_cell";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, new ItemBlockBattery(this), this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileEntityBatteryCell.class, "cyclicmagic" + this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "cbc", "bab", "cbc", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('b'), "obsidian", Character.valueOf('a'), "blockRedstone");
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityBatteryCell(this.capacity);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null);
            if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                EnergyStore storage = (EnergyStore)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
                storage.setEnergyStored(handlerHere.getEnergyStored());
            }
        }
        ret.add(stack);
        return ret;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            TileEntityBatteryCell container = (TileEntityBatteryCell)world.func_175625_s(pos);
            container.setEnergyCurrent(storage.getEnergyStored());
        } else if (stack.func_77978_p() != null && world.func_175625_s(pos) instanceof TileEntityBatteryCell) {
            NBTTagCompound tags = stack.func_77978_p();
            int energy = tags.func_74762_e("energy");
            TileEntityBatteryCell container = (TileEntityBatteryCell)world.func_175625_s(pos);
            container.setEnergyCurrent(energy);
        }
    }
}

