/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei.categories;

import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public abstract class CategoryBase<T extends IRecipeWrapper>
implements IRecipeCategory<T> {
    private static final ResourceLocation widgetTexture = new ResourceLocation("gendustryjei", "textures/gui/widgets.png");
    protected static IDrawable tankOverlay;
    protected static IDrawable tankBackground;
    protected static IDrawable energyOverlay;
    protected static IDrawable itemSlotBackground;
    protected static IDrawable arrowBackground;
    protected static IDrawable arrowAnimated;
    protected final int energyX = 0;
    protected final int energyY = 0;
    protected int rfPerItem;
    private final Item machine;
    private String localizedName;
    private static List<String> tooltipList;

    public static void loadWidgets(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        tankOverlay = helper.createDrawable(widgetTexture, 19, 1, 16, 58);
        tankBackground = helper.createDrawable(widgetTexture, 0, 0, 18, 60);
        IDrawableStatic energyStatic = helper.createDrawable(widgetTexture, 0, 60, 18, 60);
        energyOverlay = helper.createAnimatedDrawable(energyStatic, 80, IDrawableAnimated.StartDirection.TOP, true);
        itemSlotBackground = helper.createDrawable(widgetTexture, 36, 0, 18, 18);
        arrowBackground = helper.createDrawable(widgetTexture, 54, 0, 53, 15);
        IDrawableStatic arrowWhite = helper.createDrawable(widgetTexture, 54, 30, 53, 15);
        arrowAnimated = helper.createAnimatedDrawable(arrowWhite, 54, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public CategoryBase(Item machine) {
        this.machine = machine;
        this.localizedName = Translator.translateToLocal((String)(machine.func_77658_a() + ".name"));
    }

    protected void drawArrow(Minecraft minecraft, int x, int y) {
        arrowBackground.draw(minecraft, x, y);
        arrowAnimated.draw(minecraft, x, y);
    }

    protected void drawEnergyMeter(Minecraft minecraft) {
        tankBackground.draw(minecraft, 0, 0);
        energyOverlay.draw(minecraft, 0, 0);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        tooltipList.clear();
        if (0 <= mouseX && 18 > mouseX && 0 <= mouseY && 60 > mouseY) {
            tooltipList.add("Energy: " + this.rfPerItem + " RF");
            return tooltipList;
        }
        return tooltipList;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Gendustry JEI Addon";
    }

    public Item getMachine() {
        return this.machine;
    }

    static {
        tooltipList = new ArrayList<String>();
    }
}

