/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2.features;

import de.lellson.roughmobs2.ai.combat.RoughAIDropTNT;
import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.features.EntityFeatures;
import de.lellson.roughmobs2.misc.FeatureHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GhastFeatures
extends EntityFeatures {
    private boolean projectileImmunity;
    private boolean dropTnt;
    private int explosionRadius;

    public GhastFeatures() {
        super("ghast", EntityGhast.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.projectileImmunity = RoughConfig.getBoolean(this.name, "ProjectileImmunity", true, "Set to false to prevent %ss from being immune to projectiles");
        this.dropTnt = RoughConfig.getBoolean(this.name, "DropTnt", true, "Set to false to prevent %ss from dropping primed TNT on their targets");
        this.explosionRadius = RoughConfig.getInteger(this.name, "ExplosionRadius", 3, 0, Short.MAX_VALUE, "Ghast fireball explosion radius\nThe vanilla default is 1");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityGhast && this.explosionRadius != 1) {
            ReflectionHelper.setPrivateValue(EntityGhast.class, (Object)((EntityGhast)entity), (Object)this.explosionRadius, (int)1);
        }
        if (this.dropTnt && entity instanceof EntityLiving) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIDropTNT((EntityLiving)entity));
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.projectileImmunity && event.getSource().func_76352_a() && !(immediateAttacker instanceof EntityLargeFireball)) {
            event.setCanceled(true);
            FeatureHelper.spawnParticle(target, EnumParticleTypes.SMOKE_LARGE, 5);
            FeatureHelper.playSound(target, SoundEvents.field_187807_fF);
        }
    }
}

