/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.world;

import java.io.Serializable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockData
implements Serializable {
    private final int dimId;
    private final long pos;
    private final String registryName;
    private final int meta;
    private final String nbt;
    private transient BlockPos posBP;
    private final int marker;

    public BlockData(World world, BlockPos pos, IBlockState state) {
        this(world, pos, state, null);
    }

    public BlockData(World world, BlockPos pos, IBlockState state, @Nullable TileEntity tile) {
        this.marker = 3;
        this.pos = pos.func_177986_g();
        this.dimId = world.field_73011_w.getDimension();
        this.registryName = state.func_177230_c().getRegistryName().toString();
        this.meta = state.func_177230_c().func_176201_c(state);
        this.posBP = pos;
        if (tile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            this.nbt = nbt.toString();
        } else {
            this.nbt = null;
        }
    }

    public BlockData(World world, BlockPos pos, IBlockState state, int marker) {
        this(world, pos, state, marker, null);
    }

    public BlockData(World world, BlockPos pos, IBlockState state, int marker, @Nullable TileEntity tile) {
        this.marker = marker;
        this.pos = pos.func_177986_g();
        this.dimId = world.field_73011_w.getDimension();
        this.registryName = state.func_177230_c().getRegistryName().toString();
        this.meta = state.func_177230_c().func_176201_c(state);
        this.posBP = pos;
        if (tile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            this.nbt = nbt.toString();
        } else {
            this.nbt = null;
        }
    }

    public void place(World world) {
        BlockPos pos = this.posBP != null ? this.posBP : (this.posBP = BlockPos.func_177969_a((long)this.pos));
        IBlockState state = ((Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(this.registryName))).func_176203_a(this.meta);
        TileEntity tile = null;
        try {
            tile = TileEntity.func_190200_a((World)world, (NBTTagCompound)JsonToNBT.func_180713_a((String)this.nbt));
        }
        catch (Exception exception) {
            // empty catch block
        }
        world.func_180501_a(pos, state, 3);
        if (tile != null) {
            world.func_175690_a(pos, tile);
        }
    }

    public boolean canBePlaced(World world) {
        BlockPos pos = this.posBP != null ? this.posBP : (this.posBP = BlockPos.func_177969_a((long)this.pos));
        return world.func_72863_F().func_191062_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }
}

